/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.io.File;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.internal.ui.preferences.PHPManualConfig;
import org.eclipse.php.internal.ui.preferences.PHPManualConfigurationBlock;

public class PHPManualConfigSerializer {
    private static final String INSTALL_AREA_PROP = "@osgi.install.area";

    public static String toString(PHPManualConfig config) {
        return String.valueOf(config.getLabel()) + PHPManualConfigurationBlock.PREFERENCES_DELIMITER + config.getUrl() + PHPManualConfigurationBlock.PREFERENCES_DELIMITER + config.getExtension();
    }

    public static PHPManualConfig fromStringTokenizer(StringTokenizer tokenizer) {
        int idx;
        String url = "";
        String name = "PHP.net";
        String extension = "php";
        if (!tokenizer.hasMoreTokens()) {
            return null;
        }
        name = tokenizer.nextToken();
        if (tokenizer.hasMoreTokens()) {
            url = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                extension = tokenizer.nextToken();
            }
        } else {
            url = name;
            name = "";
        }
        if ((idx = url.indexOf(INSTALL_AREA_PROP)) != -1) {
            String platformLocation = new File(Platform.getInstallLocation().getURL().getPath()).getPath();
            if (platformLocation.endsWith("/")) {
                platformLocation = platformLocation.substring(0, platformLocation.length() - 1);
            }
            url = "file://" + new File(String.valueOf(url.substring(0, idx)) + platformLocation + url.substring(idx + INSTALL_AREA_PROP.length())).getAbsolutePath();
        }
        return new PHPManualConfig(name, url, extension, false);
    }

    public static PHPManualConfig fromString(String string) {
        if (string != null && !"".equals(string)) {
            return PHPManualConfigSerializer.fromStringTokenizer(new StringTokenizer(string, PHPManualConfigurationBlock.PREFERENCES_DELIMITER));
        }
        return null;
    }
}

