/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import java.util.Comparator;
import org.eclipse.dltk.ui.templates.ScriptTemplateProposal;
import org.eclipse.dltk.ui.text.completion.AbstractScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.TemplateProposal;

public class CompletionProposalComparator
implements Comparator<Object> {
    private boolean fOrderAlphabetically = false;

    public void setOrderAlphabetically(boolean orderAlphabetically) {
        this.fOrderAlphabetically = orderAlphabetically;
    }

    @Override
    public int compare(Object o1, Object o2) {
        ICompletionProposal p1 = (ICompletionProposal)o1;
        ICompletionProposal p2 = (ICompletionProposal)o2;
        if (!this.fOrderAlphabetically) {
            return this.compareRelevance(p1, p2);
        }
        return this.compareAlphabetically(p1, p2);
    }

    public int compareAlphabetically(ICompletionProposal p1, ICompletionProposal p2) {
        return this.getSortKey(p1).compareToIgnoreCase(this.getSortKey(p2));
    }

    public int compareRelevance(ICompletionProposal p1, ICompletionProposal p2) {
        int relevanceDif = this.getRelevance(p2) - this.getRelevance(p1);
        if (relevanceDif != 0) {
            return relevanceDif;
        }
        relevanceDif = this.compareAlphabetically(p1, p2);
        if (relevanceDif != 0) {
            return relevanceDif;
        }
        return this.getSubRelevance(p2) - this.getSubRelevance(p1);
    }

    private String getSortKey(ICompletionProposal p) {
        if (p instanceof AbstractScriptCompletionProposal) {
            String sortString = ((AbstractScriptCompletionProposal)p).getSortString();
            if (sortString != null) {
                return sortString;
            }
        } else if (p instanceof ScriptTemplateProposal) {
            return ((ScriptTemplateProposal)p).getTemplateName();
        }
        return p.getDisplayString();
    }

    private int getRelevance(ICompletionProposal obj) {
        if (obj instanceof IScriptCompletionProposal) {
            IScriptCompletionProposal jcp = (IScriptCompletionProposal)obj;
            return jcp.getRelevance();
        }
        if (obj instanceof TemplateProposal) {
            TemplateProposal tp = (TemplateProposal)obj;
            return tp.getRelevance();
        }
        return 0;
    }

    private int getSubRelevance(ICompletionProposal obj) {
        if (obj instanceof IScriptCompletionProposal) {
            return 1;
        }
        if (obj instanceof TemplateProposal) {
            return 2;
        }
        return 0;
    }
}

