/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.wizards;

import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.profile.core.engine.ProfileSessionsManager;
import org.eclipse.php.profile.core.engine.ProfilerDB;
import org.eclipse.php.profile.ui.PHPProfileUIMessages;
import org.eclipse.php.profile.ui.wizards.ProfileSessionsContentProvider;
import org.eclipse.php.profile.ui.wizards.ProfileSessionsLabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ExportSessionWizardFirstPage
extends WizardPage {
    private Listener fieldModifyListener = new Listener(){

        public void handleEvent(Event e) {
            boolean valid = ExportSessionWizardFirstPage.this.validatePage();
            ExportSessionWizardFirstPage.this.setPageComplete(valid);
        }
    };
    private Text fTargetFileField;
    private Button fTargetBtn;
    private String fTargetFile;
    private TableViewer fTableViewer;
    private ProfilerDB fInitSession;
    private ProfilerDB[] fSessions;

    public ExportSessionWizardFirstPage(ProfilerDB session) {
        super(PHPProfileUIMessages.getString("ExportSessionWizardPage1.0"));
        this.setTitle(PHPProfileUIMessages.getString("ExportSessionWizardPage1.1"));
        this.setDescription(PHPProfileUIMessages.getString("ExportSessionWizardPage1.12"));
        this.setPageComplete(false);
        this.fInitSession = session;
    }

    public String getTargetFile() {
        return this.fTargetFile;
    }

    public ProfilerDB[] getSessions() {
        return this.fSessions;
    }

    private void createSelectSessionGroup(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(PHPProfileUIMessages.getString("ExportSessionWizardPage1.2"));
        this.fTableViewer = new TableViewer(parent, 2050);
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.convertHeightInCharsToPixels(8);
        this.fTableViewer.getControl().setLayoutData((Object)gridData);
        this.fTableViewer.setContentProvider((IContentProvider)new ProfileSessionsContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new ProfileSessionsLabelProvider());
        this.fTableViewer.setInput((Object)ProfileSessionsManager.getSessions());
        if (this.fInitSession != null) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)this.fInitSession));
        }
    }

    private void createTargetFileGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PHPProfileUIMessages.getString("ExportSessionWizardPage1.3"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        GridData data = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)data);
        Label label = new Label((Composite)group, 0);
        label.setText(PHPProfileUIMessages.getString("ExportSessionWizardPage1.4"));
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.fTargetFileField = new Text((Composite)group, 2048);
        data = new GridData(768);
        data.horizontalIndent = this.convertWidthInCharsToPixels(2);
        this.fTargetFileField.setLayoutData((Object)data);
        this.fTargetFileField.addListener(24, this.fieldModifyListener);
        this.fTargetBtn = new Button((Composite)group, 0);
        this.fTargetBtn.setText(PHPProfileUIMessages.getString("ExportSessionWizardPage1.5"));
        this.fTargetBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedFile;
                FileDialog dialog = new FileDialog(ExportSessionWizardFirstPage.this.getShell(), 8192);
                dialog.setText(PHPProfileUIMessages.getString("ExportSessionWizardPage1.6"));
                dialog.setFilterExtensions(new String[]{"*.xml"});
                String dirName = new File(ExportSessionWizardFirstPage.this.fTargetFileField.getText().trim()).getParent();
                if (dirName != null && dirName.length() > 0 && new File(dirName).exists()) {
                    dialog.setFilterPath(new Path(dirName).toOSString());
                }
                if ((selectedFile = dialog.open()) != null) {
                    int dotIndex = selectedFile.lastIndexOf(46);
                    if (dotIndex == -1) {
                        selectedFile = String.valueOf(selectedFile) + ".xml";
                    }
                    ExportSessionWizardFirstPage.this.fTargetFileField.setText(selectedFile);
                }
            }
        });
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.createSelectSessionGroup(composite);
        this.createTargetFileGroup(composite);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.php.help.exporting_profile_sessions");
    }

    protected boolean validatePage() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Object[] elements = selection.toArray();
        if (elements == null || elements.length == 0) {
            this.setErrorMessage(null);
            this.setMessage(PHPProfileUIMessages.getString("ExportSessionWizardPage1.7"));
            return false;
        }
        this.fSessions = new ProfilerDB[elements.length];
        System.arraycopy(elements, 0, this.fSessions, 0, elements.length);
        String targetFile = this.fTargetFileField.getText().trim();
        if (targetFile.length() == 0) {
            this.setErrorMessage(null);
            this.setMessage(PHPProfileUIMessages.getString("ExportSessionWizardPage1.8"));
            return false;
        }
        File file = new File(targetFile);
        if (file.isDirectory()) {
            this.setMessage(null);
            this.setErrorMessage(PHPProfileUIMessages.getString("ExportSessionWizardPage1.9"));
            return false;
        }
        File parentFile = file.getParentFile();
        if (parentFile == null) {
            this.setMessage(null);
            this.setErrorMessage(PHPProfileUIMessages.getString("ExportSessionWizardPage1.10"));
            return false;
        }
        if (!parentFile.isDirectory()) {
            this.setMessage(null);
            this.setErrorMessage(NLS.bind((String)PHPProfileUIMessages.getString("ExportSessionWizardPage1.11"), (Object)file.getParent()));
            return false;
        }
        this.fTargetFile = targetFile;
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }
}

