/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.vpg;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.photran.internal.core.util.Pair;
import org.eclipse.photran.internal.core.vpg.ASTRepository;
import org.eclipse.photran.internal.core.vpg.DemandDB;
import org.eclipse.photran.internal.core.vpg.IVPGComponentFactory;
import org.eclipse.photran.internal.core.vpg.IVPGNode;
import org.eclipse.photran.internal.core.vpg.Messages;
import org.eclipse.photran.internal.core.vpg.VPGDB;
import org.eclipse.photran.internal.core.vpg.VPGEdge;
import org.eclipse.photran.internal.core.vpg.VPGLog;
import org.eclipse.photran.internal.core.vpg.VPGWriter;

public abstract class VPG<A, T, R extends IVPGNode<T>> {
    private final IVPGComponentFactory<A, T, R> factory;
    private final VPGWriter<A, T, R> vpgWriter;
    private final ASTRepository<A> astCache;
    private final DemandDB<A, T, R> db;
    private final VPGLog<T, R> log;

    protected VPG(IVPGComponentFactory<A, T, R> factory) {
        this(factory, 5);
    }

    protected VPG(IVPGComponentFactory<A, T, R> factory, int transientASTCacheSize) {
        assert (transientASTCacheSize > 0);
        this.factory = factory;
        this.log = factory.createLog();
        this.db = new DemandDB<A, T, R>(factory.createDatabase(this.log));
        this.vpgWriter = factory.createVPGWriter(this.db, this.log);
        this.db.setContentProvider(this.vpgWriter);
        this.astCache = new ASTRepository(transientASTCacheSize);
    }

    public <W extends VPGWriter<A, T, R>> W getVPGWriter() {
        return (W)this.vpgWriter;
    }

    public VPGLog<T, R> getLog() {
        return this.log;
    }

    VPGDB<A, T, R> getDB() {
        return this.db;
    }

    protected abstract A parse(String var1);

    public final A acquireTransientAST(String filename) {
        return this.astCache.acquireTransientAST(filename, false, this);
    }

    public final A acquirePermanentAST(String filename) {
        return this.astCache.acquirePermanentAST(filename, this);
    }

    public final A makeTransientASTPermanent(String filename) {
        return (A)this.astCache.makeTransientASTPermanent(filename, this);
    }

    public final A makeTransientASTPermanent(String filename, A ast) {
        return this.astCache.makeTransientASTPermanent(filename, ast);
    }

    public final void releaseAST(String filename) {
        this.astCache.releaseAST(filename);
    }

    public final void releaseAllASTs() {
        this.astCache.releaseAllASTs();
    }

    public final String getFilenameCorrespondingTo(A ast) {
        return this.astCache.getFilenameCorrespondingTo(ast);
    }

    public final R getVPGNode(String filename, int offset, int length) {
        return this.factory.getVPGNode(filename, offset, length);
    }

    public Iterable<String> listAllFilenamesWithDependents() {
        return this.db.listAllFilenamesWithDependents();
    }

    public Iterable<String> listAllDependentFilenames() {
        return this.db.listAllDependentFilenames();
    }

    public Iterable<String> getOutgoingDependenciesFrom(String filename) {
        return this.db.getOutgoingDependenciesFrom(filename);
    }

    public Iterable<String> getIncomingDependenciesTo(String filename) {
        return this.db.getIncomingDependenciesTo(filename);
    }

    public List<String> sortFilesAccordingToDependencies(List<String> files) {
        return this.db.sortFilesAccordingToDependencies(files);
    }

    public Iterable<? extends VPGEdge<A, T, R>> getAllEdgesFor(String filename) {
        return this.db.getAllEdgesFor(filename);
    }

    public Iterable<Pair<R, Integer>> getAllAnnotationsFor(String filename) {
        return this.db.getAllAnnotationsFor(filename);
    }

    public void commitChangesFromInMemoryASTs(IProgressMonitor pm, int ticks, String ... filenames) {
        List<String> files = new ArrayList<String>(Arrays.asList(filenames));
        files = this.sortFilesAccordingToDependencies(files);
        pm = new SubProgressMonitor(pm, ticks, 4);
        pm.beginTask(Messages.VPG_PostTransformAnalysis, files.size());
        for (String thisFile : files) {
            if (!this.isVirtualFile(thisFile)) {
                pm.subTask(VPG.lastSegmentOfFilename(thisFile));
                this.vpgWriter.computeEdgesAndAnnotationsFromModifiedAST(thisFile, this.acquireTransientAST(thisFile));
            }
            pm.worked(1);
        }
        pm.done();
    }

    public static String lastSegmentOfFilename(String filename) {
        if (filename == null) {
            return "";
        }
        int lastSlash = filename.lastIndexOf(47);
        int lastBackslash = filename.lastIndexOf(92);
        if (lastSlash < 0 && lastBackslash < 0) {
            return filename;
        }
        return filename.substring(Math.max(lastSlash + 1, lastBackslash + 1));
    }

    public String getSourceCodeFromAST(A ast) {
        return null;
    }

    public Iterable<String> listAllFilenames() {
        return this.db.listAllFilenames();
    }

    public boolean isOutOfDate(String filename) {
        return this.db.isOutOfDate(filename);
    }

    public boolean isVirtualFile(String filename) {
        return false;
    }

    public boolean shouldProcessFile(String filename) {
        return !this.isVirtualFile(filename);
    }

    public void enterHypotheticalMode() throws IOException {
        this.db.enterHypotheticalMode();
    }

    public void leaveHypotheticalMode() throws IOException {
        this.db.leaveHypotheticalMode();
    }

    public boolean isInHypotheticalMode() {
        return this.db.isInHypotheticalMode();
    }

    public final void forceRecomputationOfDependencies(String filename) {
        this.vpgWriter.computeDependencies(filename);
    }

    public final void forceRecomputationOfEdgesAndAnnotations(String filename) {
        this.releaseAST(filename);
        this.astCache.acquireTransientAST(filename, true, this);
    }

    public void deleteAllEntriesFor(String filename) {
        this.log.clearEntriesFor(filename);
        this.db.deleteAllEntriesFor(filename);
    }

    public void resetDatabaseStatistics() {
        this.db.resetStatistics();
    }

    public void printDatabaseStatisticsOn(PrintStream out) {
        this.db.printStatisticsOn(out);
    }

    public void printDatabaseOn(PrintStream out) {
        this.db.printOn(out);
    }

    public void clearDatabase() {
        this.db.clearDatabase();
    }

    public void flushDatabase() {
        this.db.flush();
    }

    public void close() {
        this.db.close();
    }

    public String describeEdgeType(int edgeType) {
        return Messages.bind((String)Messages.VPG_EdgeOfType, (Object)edgeType);
    }

    public String describeAnnotationType(int annotationType) {
        return Messages.bind((String)Messages.VPG_AnnotationOfType, (Object)annotationType);
    }

    public void debug(String message, String filename) {
    }
}

