/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.parser;

import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.Parser;

abstract class ParsingTables {
    public static final int ACTION_MASK = 49152;
    public static final int VALUE_MASK = 16383;
    public static final int SHIFT_ACTION = 32768;
    public static final int REDUCE_ACTION = 16384;
    public static final int ACCEPT_ACTION = 49152;
    public static final int DISCARD_STATE_ACTION = 0;
    public static final int DISCARD_TERMINAL_ACTION = 32768;
    public static final int RECOVER_ACTION = 16384;

    ParsingTables() {
    }

    public abstract int getActionCode(int var1, Token var2);

    public abstract int getActionCode(int var1, int var2);

    public abstract int getGoTo(int var1, Parser.Nonterminal var2);

    public abstract int getRecoveryCode(int var1, Token var2);

    protected static final int base64Decode(byte[] decodeIntoBuffer, String encodedString) {
        int[] encodedBuffer = new int[4];
        int bytesDecoded = 0;
        int inputLength = encodedString.length();
        if (inputLength % 4 != 0) {
            throw new IllegalArgumentException("Invalid Base64-encoded data (wrong length)");
        }
        int inputOffset = 0;
        while (inputOffset < inputLength) {
            int padding = 0;
            int i = 0;
            while (i < 4) {
                char value = encodedString.charAt(inputOffset + i);
                if (value >= 'A' && value <= 'Z') {
                    encodedBuffer[i] = value - 65;
                } else if (value >= 'a' && value <= 'z') {
                    encodedBuffer[i] = value - 97 + 26;
                } else if (value >= '0' && value <= '9') {
                    encodedBuffer[i] = value - 48 + 52;
                } else if (value == '+') {
                    encodedBuffer[i] = 62;
                } else if (value == '/') {
                    encodedBuffer[i] = 63;
                } else if (value == '=') {
                    encodedBuffer[i] = 0;
                    ++padding;
                } else {
                    throw new IllegalArgumentException("Invalid character " + value + " in Base64-encoded data");
                }
                ++i;
            }
            assert (padding >= 0 && padding <= 2);
            decodeIntoBuffer[bytesDecoded + 0] = (byte)((encodedBuffer[0] & 0x3F) << 2 | (encodedBuffer[1] & 0x30) >>> 4);
            if (padding < 2) {
                decodeIntoBuffer[bytesDecoded + 1] = (byte)((encodedBuffer[1] & 0xF) << 4 | (encodedBuffer[2] & 0x3C) >>> 2);
            }
            if (padding < 1) {
                decodeIntoBuffer[bytesDecoded + 2] = (byte)((encodedBuffer[2] & 3) << 6 | encodedBuffer[3] & 0x3F);
            }
            bytesDecoded += 3 - padding;
            inputOffset += 4;
        }
        return bytesDecoded;
    }
}

