/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.photran.internal.core.lexer.IAccumulatingLexer;
import org.eclipse.photran.internal.core.lexer.ILexer;
import org.eclipse.photran.internal.core.lexer.LexerPhase3;
import org.eclipse.photran.internal.core.sourceform.ISourceForm;
import org.eclipse.photran.internal.core.sourceform.SourceForm;

public class ASTLexerFactory {
    public IAccumulatingLexer createLexer(IFile file) throws CoreException, IOException {
        return this.createLexer(new BufferedReader(new InputStreamReader(file.getContents(true), file.getCharset())), file, SourceForm.determineFilename((IFile)file));
    }

    public IAccumulatingLexer createLexer(IFile file, ISourceForm sourceForm) throws CoreException, IOException {
        return this.createLexer(new BufferedReader(new InputStreamReader(file.getContents(true), file.getCharset())), file, SourceForm.determineFilename((IFile)file), sourceForm);
    }

    public IAccumulatingLexer createLexer(File file) throws IOException {
        return this.createLexer(new BufferedReader(new FileReader(file)), null, file.getAbsolutePath());
    }

    public IAccumulatingLexer createLexer(File file, ISourceForm sourceForm) throws IOException {
        return this.createLexer(new BufferedReader(new FileReader(file)), null, file.getAbsolutePath(), sourceForm);
    }

    public IAccumulatingLexer createLexer(Reader in, IFile file, String filename) throws IOException {
        return this.createLexer(in, file, filename, SourceForm.of((IFile)file, (String)filename));
    }

    public IAccumulatingLexer createLexer(Reader in, IFile file, String filename, ISourceForm sourceForm) throws IOException {
        return new LexerPhase3((ILexer)sourceForm.createLexer(in, file, filename, true));
    }
}

