/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.version;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.version.IBuildState;
import org.eclipse.pde.core.IModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildState
implements IBuildState,
Serializable {
    private static final long serialVersionUID = 2L;
    private Map<String, String> arguments;
    private byte[] releaseSpecDigest;
    private long propertiesTimeStamp;
    private boolean deviations;
    private boolean integration;
    private boolean service;
    private Set<String> rootProjects;
    private Set<String> ignoredReferences;
    private Map<String, Long> validatorTimeStamps = new LinkedHashMap<String, Long>();
    private String validatorClass;
    private String validatorVersion;
    private byte[] validatorBytes;
    private transient Map<String, Serializable> validatorStates;
    private transient boolean changedSinceRelease;

    BuildState() {
    }

    @Override
    public Map<String, String> getArguments() {
        return this.arguments == null ? new HashMap() : this.arguments;
    }

    @Override
    public void setArguments(Map<String, String> arguments) {
        this.arguments = arguments;
    }

    public byte[] getReleaseSpecDigest() {
        return this.releaseSpecDigest;
    }

    public void setReleaseSpecDigest(byte[] releaseSpecDigest) {
        this.releaseSpecDigest = releaseSpecDigest;
    }

    public long getPropertiesTimeStamp() {
        return this.propertiesTimeStamp;
    }

    public void setPropertiesTimeStamp(long propertiesTimeStamp) {
        this.propertiesTimeStamp = propertiesTimeStamp;
    }

    public boolean isDeviations() {
        return this.deviations;
    }

    public void setDeviations(boolean deviations) {
        this.deviations = deviations;
    }

    public boolean isIntegration() {
        return this.integration;
    }

    public void setIntegration(boolean integration) {
        this.integration = integration;
    }

    public boolean isService() {
        return this.service;
    }

    public void setService(boolean service) {
        this.service = service;
    }

    public Set<String> getRootProjects() {
        return this.rootProjects;
    }

    public void setRootProjects(Set<String> rootProjects) {
        this.rootProjects = rootProjects;
    }

    public Set<String> getIgnoredReferences() {
        return this.ignoredReferences;
    }

    public void setIgnoredReferences(Set<String> ignoredReferences) {
        this.ignoredReferences = ignoredReferences;
    }

    @Override
    public long getValidatorTimeStamp(IModel model) {
        Long result = this.validatorTimeStamps.get(model.getUnderlyingResource().getProjectRelativePath().toString());
        return result == null ? 0L : result;
    }

    @Override
    public void setValidatorTimeStamp(IModel model, long validatorTimeStamp) {
        this.validatorTimeStamps.put(this.getKey(model), validatorTimeStamp);
    }

    public String getValidatorClass() {
        return this.validatorClass;
    }

    public void setValidatorClass(String validatorClass) {
        this.validatorClass = validatorClass;
    }

    public String getValidatorVersion() {
        return this.validatorVersion;
    }

    public void setValidatorVersion(String validatorVersion) {
        this.validatorVersion = validatorVersion;
    }

    public boolean isChangedSinceRelease() {
        return this.changedSinceRelease;
    }

    @Override
    public void setChangedSinceRelease(boolean changedSinceRelease) {
        this.changedSinceRelease = changedSinceRelease;
    }

    @Override
    public Serializable getValidatorState(IModel model) {
        if (this.validatorStates == null) {
            this.validatorStates = this.validatorBytes != null ? (Map<Object, Object>)((Object)IOUtil.deserialize((byte[])this.validatorBytes)) : new LinkedHashMap<String, Serializable>();
        }
        return this.validatorStates.get(this.getKey(model));
    }

    @Override
    public void setValidatorState(IModel model, Serializable validatorState) {
        if (this.validatorStates == null) {
            this.validatorStates = new LinkedHashMap<String, Serializable>();
        }
        this.validatorStates.put(this.getKey(model), validatorState);
        this.validatorBytes = null;
    }

    @Override
    public void clearValidatorStates() {
        this.validatorStates = null;
        this.validatorBytes = null;
    }

    void serializeValidatorState() {
        if (this.validatorBytes == null && this.validatorStates != null) {
            this.validatorBytes = IOUtil.serialize((Serializable)((Serializable)((Object)this.validatorStates)));
        }
    }

    private String getKey(IModel model) {
        return model.getUnderlyingResource().getProjectRelativePath().toString();
    }
}

