/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.notifications.core;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.notifications.core.IFilterable;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class NotificationEnvironment {
    private final Dictionary<Object, Object> environment = new Hashtable<Object, Object>(System.getProperties());

    public Version getFrameworkVersion() {
        return CoreUtil.getFrameworkVersion();
    }

    public Version getPlatformVersion() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.platform");
        if (bundle == null) {
            bundle = Platform.getBundle((String)"org.eclipse.core.runtime");
        }
        if (bundle != null) {
            String versionString = (String)bundle.getHeaders().get("Bundle-Version");
            try {
                return new Version(versionString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Version.emptyVersion;
    }

    public Version getRuntimeVersion() {
        return CoreUtil.getRuntimeVersion();
    }

    public boolean matches(IAdaptable item, IProgressMonitor monitor) {
        IFilterable entry = (IFilterable)item.getAdapter(IFilterable.class);
        if (entry == null) {
            return true;
        }
        if (!this.matchesVersion(entry.getFilter("frameworkVersion"), this.getFrameworkVersion())) {
            return false;
        }
        if (!this.matchesVersion(entry.getFilter("platformVersion"), this.getPlatformVersion())) {
            return false;
        }
        if (!this.matchesVersion(entry.getFilter("runtimeVersion"), this.getRuntimeVersion())) {
            return false;
        }
        List<String> filterExpressions = entry.getFilters("filter");
        for (String filterExpression : filterExpressions) {
            try {
                Filter filter = FrameworkUtil.createFilter((String)filterExpression);
                if (filter.match(this.environment)) continue;
                return false;
            }
            catch (InvalidSyntaxException filter) {
                // empty catch block
            }
        }
        List<String> requiredFeatures = entry.getFilters("requires");
        for (String requiredFeature : requiredFeatures) {
            if (this.getInstalledFeatures(monitor).contains(this.parseFeature(requiredFeature))) continue;
            return false;
        }
        List<String> conflictedFeatures = entry.getFilters("conflicts");
        for (String conflictedFeature : conflictedFeatures) {
            if (!this.getInstalledFeatures(monitor).contains(this.parseFeature(conflictedFeature))) continue;
            return false;
        }
        return true;
    }

    public Set<String> getInstalledFeatures(IProgressMonitor monitor) {
        return Collections.emptySet();
    }

    private boolean matchesVersion(String expectedVersionRangeExpression, Version actualVersion) {
        if (expectedVersionRangeExpression != null) {
            try {
                VersionRange versionRange = new VersionRange(expectedVersionRangeExpression);
                if (!versionRange.isIncluded(actualVersion)) {
                    return false;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return true;
    }

    private String parseFeature(String requiredFeature) {
        int i = requiredFeature.indexOf(";");
        if (i != -1) {
            return requiredFeature.substring(0, i);
        }
        return requiredFeature;
    }
}

