/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.common.core.internal.builder;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.modisco.infra.common.core.internal.CommonModiscoActivator;
import org.eclipse.modisco.infra.common.core.internal.builder.IModiscoBuilder;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModiscoProjectBuilder
extends IncrementalProjectBuilder {
    private static final String EXTENSION_POINT_ID = "org.eclipse.modisco.common.core.builder.register";
    public static final String BUILDER_NAME = "org.eclipse.modisco.common.core.builder";
    private static ArrayList<BuilderDescriptor> modiscoBuilders = null;
    private static Object modiscoBuildersLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModiscoProjectBuilder() {
        Object object = modiscoBuildersLock;
        synchronized (object) {
            if (modiscoBuilders == null) {
                IConfigurationElement[] configs;
                modiscoBuilders = new ArrayList();
                IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
                int n = configs.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement config = iConfigurationElementArray[n2];
                    try {
                        String id = config.getDeclaringExtension().getUniqueIdentifier();
                        IModiscoBuilder builderInst = (IModiscoBuilder)config.createExecutableExtension("class");
                        BuilderDescriptor builderDescriptor = new BuilderDescriptor(builderInst, id);
                        modiscoBuilders.add(builderDescriptor);
                        IConfigurationElement[] iConfigurationElementArray2 = config.getChildren("depends");
                        int n3 = iConfigurationElementArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement depends = iConfigurationElementArray2[n4];
                            builderDescriptor.getDependsOn().add(depends.getAttribute("builder"));
                            ++n4;
                        }
                    }
                    catch (Exception e) {
                        MoDiscoLogger.logError(e, (Plugin)CommonModiscoActivator.getDefault());
                    }
                    ++n2;
                }
                modiscoBuilders = this.sortBuilders(modiscoBuilders);
            }
        }
        this.validateBuilderDependencies();
    }

    private ArrayList<BuilderDescriptor> sortBuilders(ArrayList<BuilderDescriptor> builders) {
        ArrayList<BuilderDescriptor> result = new ArrayList<BuilderDescriptor>();
        LinkedList<BuilderDescriptor> remaining = new LinkedList<BuilderDescriptor>();
        remaining.addAll(builders);
        while (!remaining.isEmpty()) {
            boolean stuck = true;
            ListIterator listIterator = remaining.listIterator();
            while (listIterator.hasNext()) {
                BuilderDescriptor builder = (BuilderDescriptor)listIterator.next();
                if (!this.dependensOnlyOn(builder, result)) continue;
                result.add(builder);
                listIterator.remove();
                stuck = false;
            }
            if (!stuck) continue;
            throw new RuntimeException("Cannot order builders due to incoherent dependencies");
        }
        return result;
    }

    private boolean dependensOnlyOn(BuilderDescriptor builder, ArrayList<BuilderDescriptor> list) {
        List<String> dependsOn = builder.getDependsOn();
        for (String dep : dependsOn) {
            boolean found = false;
            for (BuilderDescriptor prev : list) {
                if (!prev.getId().equals(dep)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private void validateBuilderDependencies() {
        ArrayList<String> idList = new ArrayList<String>();
        for (BuilderDescriptor descriptor : modiscoBuilders) {
            idList.add(descriptor.getId());
        }
        for (BuilderDescriptor descriptor : modiscoBuilders) {
            for (String dependsOn : descriptor.getDependsOn()) {
                if (idList.contains(dependsOn)) continue;
                MoDiscoLogger.logWarning("The builder " + descriptor.getId() + " depends on " + dependsOn + " which does not exist.", (Plugin)CommonModiscoActivator.getDefault());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clean(IProgressMonitor monitor) throws CoreException {
        ArrayList<BuilderDescriptor> arrayList = modiscoBuilders;
        synchronized (arrayList) {
            for (BuilderDescriptor builder : modiscoBuilders) {
                builder.getBuilderInst().clean(this, monitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        ArrayList<BuilderDescriptor> arrayList = modiscoBuilders;
        synchronized (arrayList) {
            for (BuilderDescriptor builder : modiscoBuilders) {
                builder.getBuilderInst().build(this, kind, args, monitor);
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BuilderDescriptor {
        private final IModiscoBuilder builderInst;
        private final List<String> dependsOn = new ArrayList<String>();
        private final String id;

        public BuilderDescriptor(IModiscoBuilder builderInst, String id) {
            this.builderInst = builderInst;
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public List<String> getDependsOn() {
            return this.dependsOn;
        }

        public IModiscoBuilder getBuilderInst() {
            return this.builderInst;
        }

        public String toString() {
            return String.valueOf(this.id) + "(" + this.builderInst.getClass().getName() + ")";
        }
    }
}

