/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.ui.wizards;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.launch.TargetUriData;
import org.eclipse.m2m.internal.qvt.oml.common.project.TransformationRegistry;
import org.eclipse.m2m.internal.qvt.oml.common.ui.controls.UniSelectTransformationControl;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.TransformationControls;
import org.eclipse.m2m.internal.qvt.oml.common.ui.wizards.ITransformationSelector;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.ITransformationMaker;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformationRegistry;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.wizards.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class SelectInterpretedTransformationPage
extends WizardPage
implements ITransformationSelector {
    private QvtTransformation myTransformation;
    private final ITransformationMaker TRANSFORMATION_MAKER = new ITransformationMaker.CachedTransformationMaker();
    private final URI myTransfUri;
    private final List<TargetUriData> myTargetUris;
    private UniSelectTransformationControl myControl;

    public SelectInterpretedTransformationPage(String pageId, URI transfUri, List<TargetUriData> targetUris) {
        super(pageId);
        this.setDescription(Messages.SelectWorkspaceTransformationPage_Description);
        this.myTransfUri = transfUri;
        this.myTargetUris = targetUris;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        this.doCreateControl(composite);
        this.setControl((Control)composite);
        this.setPageComplete(this.validatePage().isOK());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.m2m.qvt.oml._transformation");
    }

    protected void doCreateControl(Composite parent) {
        UniSelectTransformationControl.SelectionListenerAdapter selectionListener = new UniSelectTransformationControl.SelectionListenerAdapter(){

            public IStatus selectionChanged(URI uri) {
                IStatus status = SelectInterpretedTransformationPage.this.validatePage();
                SelectInterpretedTransformationPage.this.setPageComplete(status.isOK());
                return status;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean accept(URI uri) {
                try {
                    QvtTransformation transformation = SelectInterpretedTransformationPage.this.TRANSFORMATION_MAKER.makeTransformation(uri);
                    List parameters = transformation.getParameters();
                    int i = 0;
                    while (true) {
                        List targetMetamodels;
                        if (i >= parameters.size() || i >= SelectInterpretedTransformationPage.this.myTargetUris.size()) {
                            return true;
                        }
                        TargetUriData.ContentProvider contentProvider = ((TargetUriData)SelectInterpretedTransformationPage.this.myTargetUris.get(i)).getContentProvider();
                        if (contentProvider != null && !(targetMetamodels = contentProvider.getMetamodels()).isEmpty()) {
                            List paramMetamodels = ((QvtTransformation.TransformationParameter)parameters.get(i)).getMetamodels();
                            int j = 0;
                            while (j < targetMetamodels.size() && j < paramMetamodels.size()) {
                                if (!((URI)targetMetamodels.get(j)).toString().equals(((EPackage)paramMetamodels.get(j)).getNsURI())) {
                                    return false;
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception exception) {
                    return false;
                }
            }

            public UniSelectTransformationControl.ISelectionListener.TreeAction getTreeAction(URI uri) {
                if (SelectInterpretedTransformationPage.this.myTransfUri == null) {
                    return UniSelectTransformationControl.ISelectionListener.TreeAction.NONE;
                }
                if (SelectInterpretedTransformationPage.this.myTransfUri.equals(uri)) {
                    return UniSelectTransformationControl.ISelectionListener.TreeAction.SELECT;
                }
                return SelectInterpretedTransformationPage.this.myTransfUri.toString().startsWith(uri.toString()) ? UniSelectTransformationControl.ISelectionListener.TreeAction.EXPAND : UniSelectTransformationControl.ISelectionListener.TreeAction.NONE;
            }
        };
        this.myControl = new UniSelectTransformationControl(parent, UniSelectTransformationControl.QVTO_FILE_FILTER, (TransformationRegistry)QvtTransformationRegistry.getInstance(), TransformationRegistry.TRANSFORMATION_FILTER, (UniSelectTransformationControl.ISelectionListener)selectionListener);
    }

    protected IStatus validatePage() {
        QvtTransformation transformation;
        this.setMessage(null);
        this.setErrorMessage(null);
        this.myTransformation = null;
        String transfName = null;
        try {
            URI uri = this.getSelectedUri();
            if (uri == null) {
                return TransformationControls.makeStatus((int)4, (String)org.eclipse.m2m.internal.qvt.oml.runtime.ui.launch.Messages.QvtLauncherTab_NoTransformationModule);
            }
            transformation = this.TRANSFORMATION_MAKER.makeTransformation(uri);
            transfName = transformation.getModuleName();
        }
        catch (Exception e) {
            this.setErrorMessage(e.getMessage());
            return TransformationControls.makeStatus((int)4, (String)e.getMessage());
        }
        this.setMessage(NLS.bind((String)org.eclipse.m2m.internal.qvt.oml.runtime.ui.launch.Messages.QvtLauncherTab_TransformationSelected, (Object)transfName));
        this.myTransformation = transformation;
        return TransformationControls.makeStatus((int)0, (String)NLS.bind((String)org.eclipse.m2m.internal.qvt.oml.runtime.ui.launch.Messages.QvtLauncherTab_TransformationSelected, (Object)transfName));
    }

    public QvtTransformation getTransformation() {
        return this.myTransformation;
    }

    public void setSelectedTransformationId(String id) {
        this.myControl.selectTransformationByUri(id);
    }

    public String getSelectedTransformationId() {
        URI selectedUri = this.getSelectedUri();
        if (selectedUri == null) {
            return null;
        }
        return selectedUri.path();
    }

    public void dispose() {
        super.dispose();
        try {
            this.TRANSFORMATION_MAKER.cleanup();
        }
        catch (MdaException mdaException) {
            // empty catch block
        }
    }

    private URI getSelectedUri() {
        return this.myControl != null ? this.myControl.getSelectedUri() : null;
    }
}

