/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.core.emf;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.core.IReferenceModel;
import org.eclipse.m2m.atl.core.emf.EMFModel;
import org.eclipse.m2m.atl.core.emf.EMFModelFactory;
import org.eclipse.m2m.atl.core.emf.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFReferenceModel
extends EMFModel
implements IReferenceModel {
    private Map<String, EObject> metaElementByName = Collections.emptyMap();
    private Set<Resource> referencedResources = new HashSet<Resource>();
    private Map<EClass, Set<EObject>> allElementsByType = new HashMap<EClass, Set<EObject>>();

    public EMFReferenceModel(EMFReferenceModel referenceModel, EMFModelFactory mf) {
        super(referenceModel, mf);
    }

    public Object getMetaElementByName(String name) {
        return this.metaElementByName.get(name);
    }

    @Override
    public boolean isModelOf(Object object) {
        Resource res = ((EObject)object).eResource();
        if (this.getResource().equals(res)) {
            return true;
        }
        return this.getReferencedResources().contains(res);
    }

    public Set<EObject> getAllElementsByType(EClass metaElement) {
        Set<EObject> ret = this.allElementsByType.get(metaElement);
        if (ret == null) {
            ret = this.getElementsByType(metaElement);
            for (Resource res : this.getReferencedResources()) {
                TreeIterator iterator = res.getAllContents();
                while (iterator.hasNext()) {
                    EObject element = (EObject)iterator.next();
                    if (!metaElement.isInstance((Object)element)) continue;
                    ret.add(element);
                }
            }
            this.allElementsByType.put(metaElement, ret);
        }
        return ret;
    }

    public void register() {
        this.registerPackages();
        this.adapt();
        this.addAllReferencedResources(this.getResource());
        this.metaElementByName = this.initMetaElementsInAllResources();
    }

    private static void register(Map<String, EObject> eClassifiers, String name, EObject classifier) {
        if (eClassifiers.containsKey(name)) {
            ATLLogger.warning((String)Messages.getString("EMFReferenceModel.SEVERAL_CLASSIFIERS", name));
        }
        eClassifiers.put(name, classifier);
    }

    private void adapt() {
        for (EDataType eDataType : this.getAllElementsByType(EcorePackage.eINSTANCE.getEDataType())) {
            String tname = eDataType.getName();
            String icn = eDataType.getInstanceClassName();
            if (icn != null) continue;
            if (tname.equals("Boolean")) {
                icn = "boolean";
            } else if (tname.equals("Double") || tname.equals("Real")) {
                icn = "java.lang.Double";
            } else if (tname.equals("Float")) {
                icn = "java.lang.Float";
            } else if (tname.equals("Integer")) {
                icn = "java.lang.Integer";
            } else if (tname.equals("String")) {
                icn = "java.lang.String";
            }
            if (icn == null) continue;
            eDataType.setInstanceClassName(icn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPackages() {
        for (EPackage ePackage : this.getElementsByType(EcorePackage.eINSTANCE.getEPackage())) {
            String nsURI = ePackage.getNsURI();
            if (nsURI == null) {
                nsURI = ePackage.getName();
                ePackage.setNsURI(nsURI);
            }
            EMFModelFactory modelFactory = this.getModelFactory();
            ResourceSet resourceSet = modelFactory.getResourceSet();
            synchronized (resourceSet) {
                modelFactory.getResourceSet().getPackageRegistry().put((Object)nsURI, (Object)ePackage);
            }
        }
    }

    private Map<String, EObject> initMetaElementsInAllResources() {
        HashMap<String, EObject> eClassifiers = new HashMap<String, EObject>();
        for (Resource res : this.getReferencedResources()) {
            EMFReferenceModel.initMetaElements(eClassifiers, res.getContents().iterator(), null);
        }
        EMFReferenceModel.initMetaElements(eClassifiers, this.getResource().getContents().iterator(), null);
        return eClassifiers;
    }

    private static void initMetaElements(Map<String, EObject> eClassifiers, Iterator<EObject> i, String base) {
        while (i.hasNext()) {
            String name;
            EObject eo = i.next();
            if (eo instanceof EPackage) {
                name = ((EPackage)eo).getName();
                if (base != null) {
                    name = String.valueOf(base) + "::" + name;
                }
                EMFReferenceModel.initMetaElements(eClassifiers, ((EPackage)eo).eContents().iterator(), name);
                continue;
            }
            if (eo instanceof EClassifier) {
                name = ((EClassifier)eo).getName();
                EMFReferenceModel.register(eClassifiers, name, eo);
                if (base == null) continue;
                name = String.valueOf(base) + "::" + name;
                EMFReferenceModel.register(eClassifiers, name, eo);
                continue;
            }
            EMFReferenceModel.initMetaElements(eClassifiers, eo.eContents().iterator(), base);
        }
    }

    protected void addAllReferencedResources(Resource resource) {
        TreeIterator contents = resource.getAllContents();
        while (contents.hasNext()) {
            Object o = contents.next();
            if (o instanceof EClass) {
                this.addReferencedResourcesFor((EClass)o, new HashSet<EClass>());
                continue;
            }
            if (!(o instanceof EGenericType) || !(((EGenericType)o).getEClassifier() instanceof EClass)) continue;
            this.addReferencedResourcesFor((EClass)((EGenericType)o).getEClassifier(), new HashSet<EClass>());
        }
        this.getReferencedResources().remove(resource);
    }

    private void addReferencedResourcesFor(EClass eClass, Set<EClass> ignore) {
        EClassifier eType;
        if (ignore.contains(eClass)) {
            return;
        }
        ignore.add(eClass);
        Set<Resource> resources = this.getReferencedResources();
        for (EReference eRef : eClass.getEReferences()) {
            if (!eRef.isContainment()) continue;
            eType = eRef.getEType();
            if (eType.eResource() != null) {
                resources.add(eType.eResource());
            } else {
                ATLLogger.warning((String)Messages.getString("EMFReferenceModel.NULL_RESOURCE", eType.toString()));
            }
            if (!(eType instanceof EClass)) continue;
            this.addReferencedResourcesFor((EClass)eType, ignore);
        }
        for (EAttribute eAtt : eClass.getEAttributes()) {
            eType = eAtt.getEType();
            if (eType.eResource() != null) {
                resources.add(eType.eResource());
                continue;
            }
            ATLLogger.warning((String)Messages.getString("EMFReferenceModel.NULL_RESOURCE", eType.toString()));
        }
        for (EClass eSuper : eClass.getESuperTypes()) {
            if (eSuper.eResource() != null) {
                resources.add(eSuper.eResource());
                this.addReferencedResourcesFor(eSuper, ignore);
                continue;
            }
            ATLLogger.warning((String)Messages.getString("EMFReferenceModel.NULL_RESOURCE", eSuper.toString()));
        }
    }

    public Set<Resource> getReferencedResources() {
        return this.referencedResources;
    }
}

