/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.workspace;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;

public class WorkspaceState {
    public static final String SYSPROP_STATEFILE_LOCATION = "m2e.workspace.state";
    private static Properties state;

    public static synchronized Properties getState() {
        block6: {
            if (state == null) {
                state = new Properties();
                try {
                    String location = System.getProperty(SYSPROP_STATEFILE_LOCATION);
                    if (location == null) break block6;
                    try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(location));){
                        state.load(in);
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return state;
    }

    public static boolean resolveArtifact(Artifact artifact) {
        String extension = artifact.getArtifactHandler().getExtension();
        File file = WorkspaceState.findArtifact(artifact.getGroupId(), artifact.getArtifactId(), extension, artifact.getClassifier(), artifact.getBaseVersion());
        if (file == null) {
            return false;
        }
        artifact.setFile(file);
        artifact.setResolved(true);
        return true;
    }

    public static File findArtifact(String groupId, String artifactId, String type, String classifier, String baseVersion) {
        String key;
        String value;
        Properties state = WorkspaceState.getState();
        if (state == null) {
            return null;
        }
        if (classifier == null) {
            classifier = "";
        }
        if ((value = state.getProperty(key = String.valueOf(groupId) + ':' + artifactId + ':' + type + ':' + classifier + ':' + baseVersion)) == null || value.length() == 0) {
            return null;
        }
        File file = new File(value);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    public static List<String> findVersions(String groupId, String artifactId) {
        Properties state = WorkspaceState.getState();
        if (state == null) {
            return Collections.emptyList();
        }
        String prefix = String.valueOf(groupId) + ':' + artifactId + ':';
        LinkedHashSet<String> versions = new LinkedHashSet<String>();
        for (Object obj : state.keySet()) {
            String key = (String)obj;
            if (!key.startsWith(prefix)) continue;
            versions.add(key.substring(key.lastIndexOf(58) + 1));
        }
        return new ArrayList<String>(versions);
    }
}

