/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.massif;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifHeapTreeNode;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifSnapshot;
import org.eclipse.linuxtools.internal.valgrind.massif.Messages;
import org.eclipse.linuxtools.valgrind.core.ValgrindParserUtils;
import org.eclipse.osgi.util.NLS;

public class MassifParser {
    private static final String COLON = ":";
    private static final String SPACE = " ";
    private static final String EQUALS = "=";
    private static final String CMD = "cmd";
    private static final String TIME_UNIT = "time_unit";
    private static final String SNAPSHOT = "snapshot";
    private static final String TIME = "time";
    private static final String MEM_HEAP_B = "mem_heap_B";
    private static final String MEM_HEAP_EXTRA_B = "mem_heap_extra_B";
    private static final String MEM_STACKS_B = "mem_stacks_B";
    private static final String HEAP_TREE = "heap_tree";
    private static final String INSTRUCTIONS = "i";
    private static final String MILLISECONDS = "ms";
    private static final String BYTES = "B";
    private static final String PEAK = "peak";
    private static final String DETAILED = "detailed";
    private static final String EMPTY = "empty";
    private Integer pid;
    private MassifSnapshot[] snapshots;

    public MassifParser(File inputFile) throws IOException {
        ArrayList<MassifSnapshot> list = new ArrayList<MassifSnapshot>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader br = new BufferedReader(new FileReader(inputFile));){
            String line;
            MassifSnapshot snapshot = null;
            String cmd = null;
            MassifSnapshot.TimeUnit unit = null;
            int n = 0;
            String filename = inputFile.getName();
            this.pid = ValgrindParserUtils.parsePID((String)filename, (String)"massif_");
            while ((line = br.readLine()) != null) {
                if (line.startsWith("cmd:")) {
                    cmd = ValgrindParserUtils.parseStrValue((String)line, (String)": ");
                    continue;
                }
                if (line.startsWith("time_unit:")) {
                    unit = this.parseTimeUnit(line);
                    continue;
                }
                if (line.startsWith(SNAPSHOT)) {
                    if (snapshot != null) {
                        list.add(snapshot);
                        ++n;
                    }
                    snapshot = new MassifSnapshot(n);
                    snapshot.setCmd(cmd);
                    snapshot.setUnit(unit);
                    continue;
                }
                if (line.startsWith("time=")) {
                    snapshot.setTime(ValgrindParserUtils.parseLongValue((String)line, (String)EQUALS));
                    continue;
                }
                if (line.startsWith("mem_heap_B=")) {
                    snapshot.setHeapBytes(ValgrindParserUtils.parseLongValue((String)line, (String)EQUALS));
                    continue;
                }
                if (line.startsWith("mem_heap_extra_B=")) {
                    snapshot.setHeapExtra(ValgrindParserUtils.parseLongValue((String)line, (String)EQUALS));
                    continue;
                }
                if (line.startsWith("mem_stacks_B=")) {
                    snapshot.setStacks(ValgrindParserUtils.parseLongValue((String)line, (String)EQUALS));
                    continue;
                }
                if (!line.startsWith("heap_tree=")) continue;
                MassifSnapshot.SnapshotType type = this.parseSnapshotType(line);
                snapshot.setType(type);
                switch (type) {
                    case DETAILED: 
                    case PEAK: {
                        MassifHeapTreeNode node = this.parseTree(snapshot, null, br);
                        node.setText(NLS.bind((String)Messages.getString("MassifParser.Snapshot_n"), (Object)n, (Object)node.getText()));
                        snapshot.setRoot(node);
                    }
                }
            }
            if (snapshot != null) {
                list.add(snapshot);
            }
            this.snapshots = list.toArray(new MassifSnapshot[list.size()]);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private MassifHeapTreeNode parseTree(MassifSnapshot snapshot, MassifHeapTreeNode parent, BufferedReader br) throws IOException {
        MassifHeapTreeNode node;
        Long numBytes;
        Integer numChildren;
        String line = br.readLine();
        if (line == null) {
            throw new IOException(Messages.getString("MassifParser.Unexpected_EOF"));
        }
        String[] parts = (line = line.trim()).split(SPACE);
        if (parts.length < 2) {
            ValgrindParserUtils.fail((String)line);
        }
        if ((numChildren = this.parseNumChildren(parts[0])) == null) {
            ValgrindParserUtils.fail((String)line);
        }
        if ((numBytes = this.parseNumBytes(parts[1])) == null) {
            ValgrindParserUtils.fail((String)line);
        }
        double percentage = numBytes.intValue() == 0 ? 0.0 : numBytes.doubleValue() / (double)snapshot.getTotal() * 100.0;
        String address = null;
        String function = null;
        String filename = null;
        int lineNo = 0;
        if (parts[2].startsWith("0x")) {
            if (parts.length < 3) {
                ValgrindParserUtils.fail((String)line);
            }
            address = parts[2].substring(0, parts[2].length() - 1);
            function = this.parseFunction(parts[3], line);
            Object[] subparts = ValgrindParserUtils.parseFilename((String)line);
            filename = (String)subparts[0];
            lineNo = (Integer)subparts[1];
            node = new MassifHeapTreeNode(parent, percentage, numBytes, address, function, filename, lineNo);
        } else {
            StringBuilder text = new StringBuilder();
            int i = 2;
            while (i < parts.length) {
                text.append(parts[i]);
                text.append(SPACE);
                ++i;
            }
            node = new MassifHeapTreeNode(parent, percentage, numBytes, text.toString().trim());
        }
        int i = 0;
        while (i < numChildren) {
            node.addChild(this.parseTree(snapshot, node, br));
            ++i;
        }
        return node;
    }

    private String parseFunction(String start, String line) throws IOException {
        String function = null;
        int ix = line.lastIndexOf(40);
        function = ix >= 0 ? line.substring(line.indexOf(start), ix) : line.substring(line.indexOf(start));
        if (function != null) {
            function = function.trim();
        } else {
            ValgrindParserUtils.fail((String)line);
        }
        return function;
    }

    private Long parseNumBytes(String string) {
        Long result = null;
        if (ValgrindParserUtils.isNumber((String)string)) {
            result = Long.parseLong(string);
        }
        return result;
    }

    private Integer parseNumChildren(String string) {
        String number;
        Integer result = null;
        if (string.length() >= 3 && ValgrindParserUtils.isNumber((String)(number = string.substring(1, string.length() - 1)))) {
            result = Integer.parseInt(number);
        }
        return result;
    }

    public Integer getPid() {
        return this.pid;
    }

    public MassifSnapshot[] getSnapshots() {
        return this.snapshots;
    }

    private MassifSnapshot.SnapshotType parseSnapshotType(String line) throws IOException {
        MassifSnapshot.SnapshotType result = null;
        String[] parts = line.split(EQUALS);
        if (parts.length > 1) {
            String type = parts[1];
            if (type.equals(EMPTY)) {
                result = MassifSnapshot.SnapshotType.EMPTY;
            } else if (type.equals(DETAILED)) {
                result = MassifSnapshot.SnapshotType.DETAILED;
            } else if (type.equals(PEAK)) {
                result = MassifSnapshot.SnapshotType.PEAK;
            }
        }
        if (result == null) {
            ValgrindParserUtils.fail((String)line);
        }
        return result;
    }

    private MassifSnapshot.TimeUnit parseTimeUnit(String line) throws IOException {
        MassifSnapshot.TimeUnit result = null;
        String[] parts = line.split(": ");
        if (parts.length > 1) {
            String type = parts[1];
            if (type.equals(INSTRUCTIONS)) {
                result = MassifSnapshot.TimeUnit.INSTRUCTIONS;
            } else if (type.equals(MILLISECONDS)) {
                result = MassifSnapshot.TimeUnit.MILLISECONDS;
            } else if (type.equals(BYTES)) {
                result = MassifSnapshot.TimeUnit.BYTES;
            }
        }
        if (result == null) {
            ValgrindParserUtils.fail((String)line);
        }
        return result;
    }
}

