/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.util.Map;
import org.eclipse.linuxtools.docker.core.IDockerLogConfig;
import org.mandas.docker.client.messages.LogConfig;

public class DockerLogConfig
implements IDockerLogConfig {
    private final String logType;
    private final Map<String, String> logOptions;

    public DockerLogConfig(LogConfig config) {
        this.logType = config.logType();
        this.logOptions = config.logOptions();
    }

    private DockerLogConfig(Builder builder) {
        this.logType = builder.logType;
        this.logOptions = builder.logOptions;
    }

    @Override
    public String logType() {
        return this.logType;
    }

    @Override
    public Map<String, String> logOptions() {
        return this.logOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String logType;
        private Map<String, String> logOptions;

        public Builder logType(String logType) {
            this.logType = logType;
            return this;
        }

        public Builder logOptions(Map<String, String> logOptions) {
            this.logOptions = logOptions;
            return this;
        }

        public IDockerLogConfig build() {
            return new DockerLogConfig(this);
        }
    }
}

