/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.editor.ui.internal.dependencies;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.libra.framework.editor.core.model.IBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleDependencyContentResult {
    private final Set<IBundle> bundles;
    private final Map<Integer, Set<IBundle>> incomingDependencies = new HashMap<Integer, Set<IBundle>>();
    private final Map<Integer, Set<IBundle>> outgoingDependencies = new HashMap<Integer, Set<IBundle>>();

    public BundleDependencyContentResult(Set<IBundle> bundles) {
        this.bundles = bundles;
    }

    public void addIncomingDependency(Integer level, IBundle bundleDependency) {
        if (!this.incomingDependencies.containsKey(level)) {
            this.incomingDependencies.put(level, new TreeSet<IBundle>(new Comparator<IBundle>(){

                @Override
                public int compare(IBundle o1, IBundle o2) {
                    return Long.valueOf(o1.getId()).compareTo(Long.valueOf(o2.getId()));
                }
            }));
        }
        this.incomingDependencies.get(level).add(bundleDependency);
    }

    public void addOutgoingDependency(Integer level, IBundle bundleDependency) {
        if (!this.outgoingDependencies.containsKey(level)) {
            this.outgoingDependencies.put(level, new TreeSet<IBundle>(new Comparator<IBundle>(){

                @Override
                public int compare(IBundle o1, IBundle o2) {
                    return Long.valueOf(o1.getId()).compareTo(Long.valueOf(o2.getId()));
                }
            }));
        }
        this.outgoingDependencies.get(level).add(bundleDependency);
    }

    public Set<IBundle> getBundles() {
        return this.bundles;
    }

    public Map<Integer, Set<IBundle>> getIncomingDependencies() {
        return this.incomingDependencies;
    }

    public Map<Integer, Set<IBundle>> getOutgoingDependencies() {
        return this.outgoingDependencies;
    }

    public Integer getIncomingDegree() {
        int degree = 0;
        for (Integer integer : this.incomingDependencies.keySet()) {
            degree = Math.max(degree, integer);
        }
        return degree;
    }

    public Integer getOutgoingDegree() {
        int degree = 0;
        for (Integer integer : this.outgoingDependencies.keySet()) {
            degree = Math.max(degree, integer);
        }
        return degree;
    }
}

