/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.editor.integration.internal.admin.osgijmx;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.libra.framework.editor.core.model.IServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceReference
implements IServiceReference {
    private final Long bundleId;
    private final String[] clazzes;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Set<Long> usingBundles = new HashSet<Long>();
    private final IServiceReference.Type type;

    public ServiceReference(IServiceReference.Type type, Long bundleId, String[] clazzes) {
        this.bundleId = bundleId;
        this.clazzes = clazzes;
        this.type = type;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String[] getClazzes() {
        return this.clazzes;
    }

    public Set<Long> getUsingBundleIds() {
        return this.usingBundles;
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void addUsingBundle(Long id) {
        this.usingBundles.add(id);
    }

    public Long getBundleId() {
        return this.bundleId;
    }

    public IServiceReference.Type getType() {
        return this.type;
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = 31 * hashCode + this.clazzes.hashCode();
        hashCode = 31 * hashCode + this.type.hashCode();
        return hashCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ServiceReference)) {
            return false;
        }
        ServiceReference that = (ServiceReference)other;
        if (!Arrays.equals(this.clazzes, that.clazzes)) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return this.type == null || this.type.equals((Object)that.type);
    }
}

