/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.editor.integration.internal.admin.osgijmx;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.libra.framework.editor.core.model.IBundle;
import org.eclipse.libra.framework.editor.core.model.IPackageExport;
import org.eclipse.libra.framework.editor.core.model.IPackageImport;
import org.eclipse.libra.framework.editor.core.model.IServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bundle
implements IBundle {
    private final Set<IPackageExport> exports = new HashSet<IPackageExport>();
    private final String id;
    private final Set<IPackageImport> imports = new HashSet<IPackageImport>();
    private final String state;
    private final String symbolicName;
    private final String version;
    private final String location;
    private final Map<String, String> headers = new HashMap<String, String>();
    private final Set<IServiceReference> registeredServices = new HashSet<IServiceReference>();
    private final Set<IServiceReference> servicesInUse = new HashSet<IServiceReference>();

    public Bundle(String id, String symbolicName, String version, String state, String location) {
        this.symbolicName = symbolicName;
        this.version = version;
        this.id = id;
        this.state = state;
        this.location = location;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Set<IPackageExport> getPackageExports() {
        return this.exports;
    }

    public String getId() {
        return this.id;
    }

    public Set<IPackageImport> getPackageImports() {
        return this.imports;
    }

    public String getState() {
        return this.state;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getVersion() {
        return this.version;
    }

    public void addPackageExport(IPackageExport pe) {
        this.exports.add(pe);
    }

    public void addPackageImport(IPackageImport pi) {
        this.imports.add(pi);
    }

    public void addRegisteredService(IServiceReference pi) {
        this.registeredServices.add(pi);
    }

    public void addUsingService(IServiceReference pi) {
        this.servicesInUse.add(pi);
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public String getLocation() {
        return this.location;
    }

    public Set<IServiceReference> getRegisteredServices() {
        return this.registeredServices;
    }

    public Set<IServiceReference> getServicesInUse() {
        return this.servicesInUse;
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = 31 * hashCode + this.id.hashCode();
        hashCode = 31 * hashCode + this.symbolicName.hashCode();
        return hashCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Bundle)) {
            return false;
        }
        Bundle that = (Bundle)other;
        if (this.id != that.id) {
            return false;
        }
        if (this.id != null && !this.id.equals(that.id)) {
            return false;
        }
        if (this.symbolicName != that.symbolicName) {
            return false;
        }
        return this.symbolicName == null || this.symbolicName.equals(that.symbolicName);
    }
}

