/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.internal.utility.EmptyTextRange;
import org.eclipse.jpt.common.core.internal.utility.JavaProjectTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ClassNameTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.context.java.JavaManagedType;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmManagedType;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextModel;
import org.eclipse.jpt.jpa.core.resource.orm.XmlManagedType;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public abstract class AbstractOrmManagedType<P extends EntityMappings>
extends AbstractOrmXmlContextModel<P>
implements OrmManagedType {
    protected XmlManagedType xmlManagedType;
    protected String class_;
    protected String name;
    protected JavaManagedType javaManagedType;

    protected AbstractOrmManagedType(P parent, XmlManagedType xmlManagedType) {
        super(parent);
        this.xmlManagedType = xmlManagedType;
        this.class_ = this.xmlManagedType.getClassName();
        this.name = this.buildName();
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.setClass_(this.xmlManagedType.getClassName());
        this.setName(this.buildName());
        this.syncJavaManagedType(monitor);
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.updateJavaManagedType(monitor);
    }

    @Override
    public XmlManagedType getXmlManagedType() {
        return this.xmlManagedType;
    }

    @Override
    public String getClass_() {
        return this.class_;
    }

    @Override
    public void setClass(String class_) {
        this.setClass_(class_);
        this.xmlManagedType.setClassName(class_);
    }

    protected void setClass_(String class_) {
        String old = this.class_;
        this.class_ = class_;
        this.firePropertyChanged("class", old, class_);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        String old = this.name;
        this.name = name;
        if (this.firePropertyChanged("name", old, name) && this.javaManagedType != null) {
            this.setJavaManagedType(null);
        }
    }

    protected String buildName() {
        return this.getEntityMappings().qualify(this.class_);
    }

    @Override
    public String getSimpleName() {
        String className = this.getName();
        return StringTools.isBlank((String)className) ? null : ClassNameTools.simpleName((String)className);
    }

    @Override
    public String getTypeQualifiedName() {
        String className = this.class_;
        if (className == null) {
            return null;
        }
        int lastPeriod = className.lastIndexOf(46);
        className = lastPeriod == -1 ? className : className.substring(lastPeriod + 1);
        className = className.replace('$', '.');
        return className;
    }

    protected TextRange getClassTextRange() {
        return this.getValidationTextRange(this.getXmlManagedType().getClassTextRange());
    }

    @Override
    public JavaManagedType getJavaManagedType() {
        return this.javaManagedType;
    }

    protected void setJavaManagedType(JavaManagedType javaManagedType) {
        JavaManagedType old = this.javaManagedType;
        this.javaManagedType = javaManagedType;
        this.firePropertyChanged("javaManagedType", old, javaManagedType);
    }

    protected void syncJavaManagedType(IProgressMonitor monitor) {
        if (this.javaManagedType != null) {
            this.javaManagedType.synchronizeWithResourceModel(monitor);
        }
    }

    protected void updateJavaManagedType(IProgressMonitor monitor) {
        if (this.getName() == null) {
            if (this.javaManagedType != null) {
                this.setJavaManagedType(null);
            }
        } else {
            JavaResourceType resourceType = this.resolveJavaResourceType();
            if (this.javaManagedType == null) {
                this.setJavaManagedType(this.buildJavaManagedType(resourceType));
            } else if (this.javaManagedType.getJavaResourceType() == resourceType) {
                this.javaManagedType.update(monitor);
            } else {
                this.setJavaManagedType(this.buildJavaManagedType(resourceType));
            }
        }
    }

    protected JavaResourceType resolveJavaResourceType() {
        if (this.name == null) {
            return null;
        }
        return (JavaResourceType)this.getJpaProject().getJavaResourceType(this.name, JavaResourceAnnotatedElement.AstNodeType.TYPE);
    }

    protected abstract JavaManagedType buildJavaManagedType(JavaResourceType var1);

    @Override
    public JavaResourceType getJavaResourceType() {
        return this.javaManagedType == null ? null : this.javaManagedType.getJavaResourceType();
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getXmlManagedType().getValidationTextRange();
        return textRange != null ? textRange : EmptyTextRange.instance();
    }

    public TextRange getFullTextRange() {
        return this.getXmlManagedType().getFullTextRange();
    }

    public boolean containsOffset(int textOffset) {
        return this.getXmlManagedType().containsOffset(textOffset);
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.classNameTouches(pos)) {
            return this.getCandidateClassNames();
        }
        return null;
    }

    protected Iterable<String> getCandidateClassNames() {
        return JavaProjectTools.getJavaClassNames((IJavaProject)this.getJavaProject());
    }

    protected boolean classNameTouches(int pos) {
        return this.getXmlManagedType().classNameTouches(pos);
    }

    @Override
    public Iterable<DeleteEdit> createDeleteTypeEdits(IType type) {
        return this.isFor(type.getFullyQualifiedName('.')) ? IterableTools.singletonIterable((Object)this.createDeleteTypeEdit()) : IterableTools.emptyIterable();
    }

    protected DeleteEdit createDeleteTypeEdit() {
        return this.getXmlManagedType().createDeleteEdit();
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return this.isFor(originalType.getFullyQualifiedName('.')) ? IterableTools.singletonIterable((Object)this.createRenameTypeEdit(originalType, newName)) : IterableTools.emptyIterable();
    }

    protected ReplaceEdit createRenameTypeEdit(IType originalType, String newName) {
        return this.getXmlManagedType().createRenameTypeEdit(originalType, newName);
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.isFor(originalType.getFullyQualifiedName('.')) ? IterableTools.singletonIterable((Object)this.createRenamePackageEdit(newPackage.getElementName())) : IterableTools.emptyIterable();
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.isIn(originalPackage) ? IterableTools.singletonIterable((Object)this.createRenamePackageEdit(newName)) : IterableTools.emptyIterable();
    }

    protected ReplaceEdit createRenamePackageEdit(String newName) {
        return this.getXmlManagedType().createRenamePackageEdit(newName);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateClass(messages);
    }

    protected void validateClass(List<IMessage> messages) {
        if (StringTools.isBlank((String)this.class_)) {
            messages.add(this.buildValidationMessage(this.getClassTextRange(), JptJpaCoreValidationMessages.MANAGED_TYPE_UNSPECIFIED_CLASS));
            return;
        }
        this.validateClassResolves(messages);
    }

    protected void validateClassResolves(List<IMessage> messages) {
        if (this.javaManagedType == null) {
            messages.add(this.buildValidationMessage(this.getClassTextRange(), JptJpaCoreValidationMessages.MANAGED_TYPE_UNRESOLVED_CLASS, this.getName()));
        }
    }

    protected EntityMappings getEntityMappings() {
        return (EntityMappings)this.parent;
    }

    @Override
    public String getDefaultPackage() {
        return this.getEntityMappings().getDefaultPersistentTypePackage();
    }

    @Override
    public boolean isFor(String typeName) {
        return ObjectTools.equals((Object)typeName, (Object)this.getName());
    }

    @Override
    public boolean isIn(IPackageFragment packageFragment) {
        String packageName = this.getPackageName();
        return ObjectTools.equals((Object)packageName, (Object)packageFragment.getElementName());
    }

    protected String getPackageName() {
        String className = this.class_;
        if (className == null) {
            return null;
        }
        int lastPeriod = className.lastIndexOf(46);
        return lastPeriod == -1 ? this.getDefaultPackage() : className.substring(0, lastPeriod);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }
}

