/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Statement;

public class YieldStatement
extends Statement {
    public static final ChildPropertyDescriptor EXPRESSION_PROPERTY = new ChildPropertyDescriptor(YieldStatement.class, "expression", Expression.class, true, false);
    private static final List PROPERTY_DESCRIPTORS;
    private boolean isImplicit = false;
    private Expression expression = null;

    static {
        ArrayList properyList = new ArrayList(2);
        YieldStatement.createPropertyList(YieldStatement.class, properyList);
        YieldStatement.addProperty(EXPRESSION_PROPERTY, properyList);
        PROPERTY_DESCRIPTORS = YieldStatement.reapPropertyList(properyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    YieldStatement(AST ast) {
        super(ast);
        this.unsupportedBelow14();
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return YieldStatement.propertyDescriptors(apiLevel);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel, boolean previewEnabled) {
        return YieldStatement.propertyDescriptors(apiLevel);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == EXPRESSION_PROPERTY) {
            if (get) {
                return this.getExpression();
            }
            this.setExpression((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final int getNodeType0() {
        return 101;
    }

    @Override
    ASTNode clone0(AST target) {
        YieldStatement result = new YieldStatement(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.copyLeadingComment(this);
        if (this.ast.apiLevel >= 12) {
            result.setExpression((Expression)ASTNode.copySubtree(target, this.getExpression()));
        }
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren && this.ast.apiLevel >= 13) {
            this.acceptChild(visitor, this.getExpression());
        }
        visitor.endVisit(this);
    }

    public Expression getExpression() {
        this.unsupportedBelow14();
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.unsupportedBelow14();
        Expression oldChild = this.expression;
        this.preReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
        this.expression = expression;
        this.postReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
    }

    public boolean isImplicit() {
        this.unsupportedBelow14();
        return this.isImplicit;
    }

    void setImplicit(boolean isImplicit) {
        this.unsupportedBelow14();
        this.isImplicit = isImplicit;
    }

    @Override
    int memSize() {
        return super.memSize() + 8;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.expression == null ? 0 : this.getExpression().treeSize());
    }
}

