/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.chess.features;

import org.eclipse.graphiti.examples.mm.chess.Board;
import org.eclipse.graphiti.examples.mm.chess.Colors;
import org.eclipse.graphiti.examples.mm.chess.Files;
import org.eclipse.graphiti.examples.mm.chess.Ranks;
import org.eclipse.graphiti.examples.mm.chess.Square;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.BoxRelativeAnchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.ICreateService;
import org.eclipse.graphiti.services.IGaLayoutService;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.graphiti.util.IColorConstant;

public class AddChessBoardFeature
extends AbstractAddShapeFeature {
    private static final int SQUARE_SIZE = 50;
    private static final int BOARD_SIZE = 400;
    private static final int FRAME_WIDTH = 20;
    private static final int FRAME_HEIGHT = 20;

    public AddChessBoardFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        if (context.getNewObject() instanceof Board && context.getTargetContainer() instanceof Diagram) {
            return context.getTargetContainer().getChildren().size() == 0;
        }
        return false;
    }

    public PictogramElement add(IAddContext context) {
        Text text;
        ICreateService createService = Graphiti.getCreateService();
        IGaLayoutService layoutService = Graphiti.getGaLayoutService();
        Board board = (Board)context.getNewObject();
        ContainerShape outerContainerShape = createService.createContainerShape((ContainerShape)this.getDiagram(), true);
        Rectangle outerRectangle = createService.createRectangle((GraphicsAlgorithmContainer)outerContainerShape);
        outerRectangle.setBackground(this.manageColor(IColorConstant.LIGHT_GRAY));
        outerRectangle.setTransparency(Double.valueOf(0.8));
        layoutService.setLocationAndSize((GraphicsAlgorithm)outerRectangle, context.getX() - 20, context.getY() - 20, 440, 440);
        Enum[] enumArray = Files.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Files file = enumArray[n2];
            if (!Files.NONE.equals((Object)file)) {
                text = createService.createText((GraphicsAlgorithmContainer)outerRectangle);
                this.setLayoutForBorderTexts(layoutService, text);
                layoutService.setLocationAndSize((GraphicsAlgorithm)text, 20 + (file.getValue() - 1) * 50, 0, 50, 20);
                text.setValue(file.getLiteral());
                text = createService.createText((GraphicsAlgorithmContainer)outerRectangle);
                this.setLayoutForBorderTexts(layoutService, text);
                layoutService.setLocationAndSize((GraphicsAlgorithm)text, 20 + (file.getValue() - 1) * 50, 420, 50, 20);
                text.setValue(file.getLiteral());
            }
            ++n2;
        }
        enumArray = Ranks.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum rank = enumArray[n2];
            if (!Ranks.NONE.equals(rank)) {
                text = createService.createText((GraphicsAlgorithmContainer)outerRectangle);
                this.setLayoutForBorderTexts(layoutService, text);
                layoutService.setLocationAndSize((GraphicsAlgorithm)text, 0, 20 + (8 - ((Ranks)rank).getValue()) * 50, 20, 50);
                text.setValue(Integer.toString(((Ranks)rank).getValue()));
                text = createService.createText((GraphicsAlgorithmContainer)outerRectangle);
                this.setLayoutForBorderTexts(layoutService, text);
                layoutService.setLocationAndSize((GraphicsAlgorithm)text, 420, 20 + (8 - ((Ranks)rank).getValue()) * 50, 20, 50);
                text.setValue(Integer.toString(((Ranks)rank).getValue()));
            }
            ++n2;
        }
        Rectangle boardRectangle = createService.createRectangle((GraphicsAlgorithmContainer)outerRectangle);
        boardRectangle.setParentGraphicsAlgorithm((GraphicsAlgorithm)outerRectangle);
        layoutService.setLocationAndSize((GraphicsAlgorithm)boardRectangle, 20, 20, 400, 400);
        this.link((PictogramElement)outerContainerShape, board);
        for (Square square : board.getSquares()) {
            ContainerShape squareShape = createService.createContainerShape(outerContainerShape, true);
            Rectangle squareRectangle = createService.createRectangle((GraphicsAlgorithmContainer)squareShape);
            layoutService.setLocationAndSize((GraphicsAlgorithm)squareRectangle, 20 + square.getOffsetX() * 50, 20 + square.getOffsetY() * 50, 50, 50);
            IColorConstant color = square.getColor() == Colors.LIGHT ? IColorConstant.WHITE : IColorConstant.BLACK;
            squareRectangle.setBackground(this.manageColor(color));
            squareRectangle.setForeground(this.manageColor(color));
            this.link((PictogramElement)squareShape, square);
            createService.createChopboxAnchor((AnchorContainer)squareShape);
            BoxRelativeAnchor relativeAnchor = createService.createBoxRelativeAnchor((AnchorContainer)squareShape);
            relativeAnchor.setRelativeHeight(0.5);
            relativeAnchor.setRelativeWidth(0.5);
            relativeAnchor.setReferencedGraphicsAlgorithm((GraphicsAlgorithm)squareRectangle);
            relativeAnchor.setUseAnchorLocationAsConnectionEndpoint(true);
            Ellipse anchorEllipse = createService.createEllipse((GraphicsAlgorithmContainer)relativeAnchor);
            layoutService.setLocationAndSize((GraphicsAlgorithm)anchorEllipse, 25, 25, 0, 0);
        }
        return outerContainerShape;
    }

    private void setLayoutForBorderTexts(IGaLayoutService layoutService, Text text) {
        text.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
        text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
        text.setForeground(this.manageColor(IColorConstant.BLACK));
        text.setFont(GraphitiUi.getGaService().manageFont(this.getDiagram(), "Arial", 12, false, true));
    }
}

