/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.wizard;

import com.google.common.base.Objects;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ui.wizard.template.AbstractFileTemplate;
import org.eclipse.xtext.ui.wizard.template.FileTemplate;
import org.eclipse.xtext.ui.wizard.template.IFileGenerator;
import org.eclipse.xtext.ui.wizard.template.StringSelectionTemplateVariable;
import org.eclipse.xtext.ui.wizard.template.StringTemplateVariable;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;

@FileTemplate(label="DOT Graph", icon="file_template.png", description="Create a GEF DOT graph.")
public final class ParameterisedDotFile
extends AbstractFileTemplate {
    private final StringSelectionTemplateVariable type = this.combo("Graph Type:", new String[]{"directed graph", "undirected graph"});
    private final StringTemplateVariable graphName = this.text("Graph name (optional):", "", "Optional name of the graph");
    private final StringTemplateVariable nodes = this.text("Number of nodes:", "1");

    protected IStatus validate() {
        Status _xifexpression = null;
        boolean _contains = this.graphName.getValue().contains(" ");
        if (_contains) {
            _xifexpression = new Status(4, "Wizard", " The name '" + this.graphName + "' may not contain spaces!");
        } else {
            Status _xifexpression_1 = null;
            boolean _matches = this.nodes.getValue().matches("[1-9][0-9]*");
            boolean _not = !_matches;
            _xifexpression_1 = _not ? new Status(4, "Wizard", " The number of nodes '" + this.nodes + "' is not a positive integer!") : null;
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public void generateFiles(IFileGenerator generator) {
        boolean _not;
        boolean _equals;
        StringBuilder nodesBuilder = new StringBuilder();
        StringBuilder edgesBuilder = new StringBuilder();
        int _parseInt = Integer.parseInt(this.nodes.getValue());
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _parseInt, true);
        for (Integer i : _doubleDotLessThan) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)(i + 1));
            _builder.append(" [label=\"label of node \\N\"]");
            _builder.newLineIfNotEmpty();
            nodesBuilder.append((CharSequence)_builder);
            if (i <= 0) continue;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)i);
            _builder_1.append(" ");
            String _value = this.type.getValue();
            _equals = Objects.equal((Object)_value, (Object)"directed graph");
            if (_equals) {
                _builder_1.append("->");
            } else {
                _builder_1.append("--");
            }
            _builder_1.append(" ");
            _builder_1.append((Object)(i + 1));
            _builder_1.append(" [label=\"an edge between nodes \\T and \\H\" fontcolor=\"red\"]");
            _builder_1.newLineIfNotEmpty();
            edgesBuilder.append((CharSequence)_builder_1);
        }
        StringConcatenation _builder = new StringConcatenation();
        String _folder = this.getFolder();
        _builder.append(_folder);
        _builder.append("/");
        String _name = this.getName();
        _builder.append(_name);
        boolean _matches = this.getName().matches(".*\\.(gv|dot)\\Z");
        boolean bl = _not = !_matches;
        if (_not) {
            _builder.append(".dot");
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("/*");
        _builder_1.newLine();
        _builder_1.append(" ");
        _builder_1.append("* This is a graph stub");
        _builder_1.newLine();
        _builder_1.append(" ");
        _builder_1.append("*/");
        _builder_1.newLine();
        String _value = this.type.getValue();
        _equals = Objects.equal((Object)_value, (Object)"directed graph");
        if (_equals) {
            _builder_1.append("digraph");
        } else {
            _builder_1.append("graph");
        }
        CharSequence _printGraphName = this.printGraphName(this.graphName);
        _builder_1.append((Object)_printGraphName);
        _builder_1.append(" {");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t");
        _builder_1.append("// global attribute statement");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("node [shape=\"ellipse\"]");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("// nodes");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append((Object)nodesBuilder, "\t");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t");
        _builder_1.append("// edges");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append((Object)edgesBuilder, "\t");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("}");
        _builder_1.newLine();
        generator.generate((CharSequence)_builder, (CharSequence)_builder_1);
    }

    private CharSequence printGraphName(StringTemplateVariable graphNameVariable) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = graphNameVariable.getValue().isEmpty();
        if (!_isEmpty) {
            _builder.append(" ");
            String _value = graphNameVariable.getValue();
            _builder.append(_value);
        }
        return _builder;
    }
}

