/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.oda.ecore.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.oda.ecore.impl.ResultSetMetaData;
import org.eclipse.emf.oda.ecore.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResultSet
implements IResultSet {
    protected final EList<?> results;
    protected int maxRows = 0;
    protected int cursor = 0;
    protected boolean wasNull = false;

    public static IResultSet create(EClassifier type, EList<?> results) {
        if (type instanceof org.eclipse.emf.ecore.EClass) {
            return new EClass((org.eclipse.emf.ecore.EClass)type, results);
        }
        return new EDataType((org.eclipse.emf.ecore.EDataType)type, results);
    }

    protected ResultSet(EList<?> results) {
        this.results = results;
    }

    public void setMaxRows(int max) throws OdaException {
        if (max < 0) {
            throw new OdaException((Throwable)new IllegalArgumentException(String.valueOf(max)));
        }
        this.maxRows = max;
    }

    public boolean next() throws OdaException {
        if (this.cursor < this.results.size() && (this.maxRows == 0 || this.cursor < this.maxRows)) {
            ++this.cursor;
            return true;
        }
        return false;
    }

    public void close() throws OdaException {
        this.cursor = 0;
    }

    public int getRow() throws OdaException {
        return this.cursor;
    }

    protected abstract Object getValue(int var1) throws OdaException;

    public String getString(int index) throws OdaException {
        this.getMetaData().getColumnType(index);
        Object value = this.getValue(index);
        return this.wasNull ? null : String.valueOf(value);
    }

    public String getString(String columnName) throws OdaException {
        return this.getString(this.findColumn(columnName));
    }

    public int getInt(int index) throws OdaException {
        switch (this.getMetaData().getColumnType(index)) {
            case 24: 
            case 26: {
                Object value = this.getValue(index);
                return this.wasNull ? 0 : Integer.valueOf(((Byte)value).byteValue());
            }
            case 27: 
            case 28: {
                Object value = this.getValue(index);
                return this.wasNull ? 0 : Integer.valueOf(((Character)value).charValue());
            }
            case 39: 
            case 40: {
                Object value = this.getValue(index);
                return this.wasNull ? 0 : (Integer)value;
            }
            case 48: 
            case 49: {
                Object value = this.getValue(index);
                return this.wasNull ? 0 : Integer.valueOf(((Short)value).shortValue());
            }
            case 43: 
            case 44: {
                Object value = this.getValue(index);
                return this.wasNull ? 0 : Integer.valueOf(((Long)value).intValue());
            }
        }
        throw new OdaException((Throwable)new IllegalArgumentException(String.valueOf(index)));
    }

    public int getInt(String columnName) throws OdaException {
        return this.getInt(this.findColumn(columnName));
    }

    public double getDouble(int index) throws OdaException {
        switch (this.getMetaData().getColumnType(index)) {
            case 31: 
            case 32: {
                Object value = this.getValue(index);
                return this.wasNull ? 0.0 : (Double)value;
            }
            case 37: 
            case 38: {
                Object value = this.getValue(index);
                return this.wasNull ? 0.0 : Double.valueOf(((Float)value).floatValue());
            }
        }
        throw new OdaException((Throwable)new IllegalArgumentException(String.valueOf(index)));
    }

    public double getDouble(String columnName) throws OdaException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int index) throws OdaException {
        switch (this.getMetaData().getColumnType(index)) {
            case 20: {
                return (BigDecimal)this.getValue(index);
            }
            case 21: {
                Object value = this.getValue(index);
                return this.wasNull ? null : new BigDecimal((BigInteger)value);
            }
        }
        throw new OdaException((Throwable)new IllegalArgumentException(String.valueOf(index)));
    }

    public BigDecimal getBigDecimal(String columnName) throws OdaException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public Date getDate(int index) throws OdaException {
        switch (this.getMetaData().getColumnType(index)) {
            case 29: {
                Object value = this.getValue(index);
                return this.wasNull ? null : new Date(((java.util.Date)value).getTime());
            }
        }
        throw new OdaException((Throwable)new IllegalArgumentException(String.valueOf(index)));
    }

    public Date getDate(String columnName) throws OdaException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(int index) throws OdaException {
        switch (this.getMetaData().getColumnType(index)) {
            case 29: {
                Object value = this.getValue(index);
                return this.wasNull ? null : new Time(((java.util.Date)value).getTime());
            }
        }
        throw new OdaException((Throwable)new IllegalArgumentException(String.valueOf(index)));
    }

    public Time getTime(String columnName) throws OdaException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(int index) throws OdaException {
        switch (this.getMetaData().getColumnType(index)) {
            case 29: {
                Object value = this.getValue(index);
                return this.wasNull ? null : new Timestamp(((java.util.Date)value).getTime());
            }
        }
        throw new OdaException((Throwable)new IllegalArgumentException(String.valueOf(index)));
    }

    public Timestamp getTimestamp(String columnName) throws OdaException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public IBlob getBlob(int index) throws OdaException {
        switch (this.getMetaData().getColumnType(index)) {
            case 25: {
                Object value = this.getValue(index);
                return this.wasNull ? null : new Blob((byte[])value);
            }
        }
        throw new OdaException((Throwable)new IllegalArgumentException(String.valueOf(index)));
    }

    public IBlob getBlob(String columnName) throws OdaException {
        return this.getBlob(this.findColumn(columnName));
    }

    public IClob getClob(int index) throws OdaException {
        switch (this.getMetaData().getColumnType(index)) {
            case 50: {
                Object value = this.getValue(index);
                return this.wasNull ? null : new Clob((String)value);
            }
        }
        throw new OdaException((Throwable)new IllegalArgumentException(String.valueOf(index)));
    }

    public IClob getClob(String columnName) throws OdaException {
        return this.getClob(this.findColumn(columnName));
    }

    public boolean getBoolean(int index) throws OdaException {
        switch (this.getMetaData().getColumnType(index)) {
            case 22: 
            case 23: {
                Object value = this.getValue(index);
                return this.wasNull ? Boolean.FALSE : (Boolean)value;
            }
        }
        throw new OdaException((Throwable)new IllegalArgumentException(String.valueOf(index)));
    }

    public boolean getBoolean(String columnName) throws OdaException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public Object getObject(int index) throws OdaException {
        switch (this.getMetaData().getColumnType(index)) {
            case 42: {
                return new JavaObject(this.getValue(index));
            }
        }
        return this.getValue(index);
    }

    public Object getObject(String columnName) throws OdaException {
        return this.getObject(this.findColumn(columnName));
    }

    public boolean wasNull() throws OdaException {
        return this.wasNull;
    }

    protected static class Blob
    implements IBlob {
        protected final byte[] data;

        protected Blob(byte[] data) {
            this.data = data;
        }

        public InputStream getBinaryStream() throws OdaException {
            return new ByteArrayInputStream(this.data);
        }

        public byte[] getBytes(long position, int length) throws OdaException {
            throw new UnsupportedOperationException();
        }

        public long length() throws OdaException {
            return this.data.length;
        }
    }

    protected static class Clob
    implements IClob {
        protected final String data;

        protected Clob(String data) {
            this.data = data;
        }

        public Reader getCharacterStream() throws OdaException {
            return new StringReader(this.data);
        }

        public String getSubString(long position, int length) throws OdaException {
            throw new UnsupportedOperationException();
        }

        public long length() throws OdaException {
            return this.data.length();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class EClass
    extends ResultSet {
        protected final ResultSetMetaData.EClass metaData;

        protected EClass(org.eclipse.emf.ecore.EClass type, EList<?> results) {
            super(results);
            this.metaData = new ResultSetMetaData.EClass(type);
        }

        public IResultSetMetaData getMetaData() throws OdaException {
            return this.metaData;
        }

        public int findColumn(String columnName) throws OdaException {
            if ("@self".equals(columnName)) {
                return 1;
            }
            EStructuralFeature feature = this.metaData.type.getEStructuralFeature(columnName);
            if (feature == null) {
                throw new OdaException((Throwable)new IllegalArgumentException(String.valueOf(columnName)));
            }
            return this.metaData.type.getFeatureID(feature) + 1;
        }

        @Override
        protected Object getValue(int index) throws OdaException {
            if (this.cursor < 1) {
                throw new OdaException((Throwable)new IllegalStateException());
            }
            EObject self = (EObject)this.results.get(this.cursor - 1);
            if (index == 1) {
                this.wasNull = false;
                return self;
            }
            Object value = self.eGet(this.metaData.type.getEStructuralFeature(index - 2));
            this.wasNull = value == null;
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class EDataType
    extends ResultSet {
        protected final ResultSetMetaData.EDataType metaData;

        protected EDataType(org.eclipse.emf.ecore.EDataType type, EList<?> results) {
            super(results);
            this.metaData = new ResultSetMetaData.EDataType(type);
        }

        public IResultSetMetaData getMetaData() throws OdaException {
            return this.metaData;
        }

        public int findColumn(String columnName) throws OdaException {
            if ("@value".equals(columnName)) {
                return 1;
            }
            throw new OdaException((Throwable)new IllegalArgumentException(String.valueOf(columnName)));
        }

        @Override
        protected Object getValue(int index) throws OdaException {
            if (this.cursor < 1) {
                throw new OdaException((Throwable)new IllegalStateException());
            }
            Object value = this.results.get(this.cursor - 1);
            this.wasNull = value == null;
            return value;
        }
    }

    public static class JavaObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected transient Object object = null;

        public JavaObject(Object object) {
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }

        public String toString() {
            return StringUtil.getText(this.object);
        }
    }
}

