/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.id;

import java.io.IOException;
import java.io.ObjectStreamException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.spi.common.id.AbstractCDOID;
import org.eclipse.emf.cdo.spi.common.id.InternalCDOIDObject;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.ref.Interner;

public final class CDOIDObjectLongImpl
extends AbstractCDOID
implements InternalCDOIDObject {
    private static final long serialVersionUID = 1L;
    private static final LongInterner INTERNER = new LongInterner();
    private final long value;

    private CDOIDObjectLongImpl(long value) {
        CheckUtil.checkArg((value != 0L ? 1 : 0) != 0, (String)"Zero not allowed");
        this.value = value;
    }

    private CDOIDObjectLongImpl() {
        this.value = 0L;
    }

    public long getLongValue() {
        return this.value;
    }

    @Override
    public void write(CDODataOutput out) throws IOException {
        out.writeXLong(this.value);
    }

    @Override
    public String toURIFragment() {
        return String.valueOf(this.value);
    }

    @Override
    public CDOID.Type getType() {
        return CDOID.Type.OBJECT;
    }

    @Override
    public boolean isExternal() {
        return false;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isTemporary() {
        return false;
    }

    @Override
    public CDOID.ObjectType getSubType() {
        return CDOID.ObjectType.LONG;
    }

    @Override
    public int hashCode() {
        return ObjectUtil.hashCode((long)this.value);
    }

    @Override
    public String toString() {
        return "OID" + this.value;
    }

    @Override
    protected int doCompareTo(CDOID o) throws ClassCastException {
        return Long.valueOf(this.value).compareTo(((CDOIDObjectLongImpl)o).value);
    }

    private Object readResolve() throws ObjectStreamException {
        return CDOIDObjectLongImpl.create(this.value);
    }

    private static int getHashCode(long value) {
        return ObjectUtil.hashCode((long)value);
    }

    public static CDOIDObjectLongImpl create(long value) {
        return INTERNER.intern(value);
    }

    public static CDOIDObjectLongImpl create(CDODataInput in) throws IOException {
        long value = in.readXLong();
        return CDOIDObjectLongImpl.create(value);
    }

    public static CDOIDObjectLongImpl create(String fragmentPart) {
        long value = Long.parseLong(fragmentPart);
        return CDOIDObjectLongImpl.create(value);
    }

    /* synthetic */ CDOIDObjectLongImpl(long l, CDOIDObjectLongImpl cDOIDObjectLongImpl) {
        this(l);
    }

    private static final class LongInterner
    extends Interner<CDOIDObjectLongImpl> {
        private LongInterner() {
        }

        public synchronized CDOIDObjectLongImpl intern(long value) {
            int hashCode = CDOIDObjectLongImpl.getHashCode(value);
            Interner.Entry entry = this.getEntry(hashCode);
            while (entry != null) {
                CDOIDObjectLongImpl id = (CDOIDObjectLongImpl)entry.get();
                if (id != null && id.value == value) {
                    return id;
                }
                entry = entry.getNextEntry();
            }
            CDOIDObjectLongImpl id = new CDOIDObjectLongImpl(value, null);
            this.addEntry(this.createEntry(id, hashCode));
            return id;
        }

        protected int hashCode(CDOIDObjectLongImpl id) {
            return CDOIDObjectLongImpl.getHashCode(id.value);
        }
    }
}

