/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.services;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.e4.core.services.translation.ResourceBundleProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ResourceBundleHelper {
    private static final String PLATFORM_SCHEMA = "platform";
    private static final String BUNDLECLASS_SCHEMA = "bundleclass";
    private static final String PLUGIN_SEGMENT = "/plugin/";
    private static final String FRAGMENT_SEGMENT = "/fragment/";
    private static final String PATH_SEPARATOR = "/";
    private static final ServiceTracker<LogService, LogService> logTracker = ResourceBundleHelper.openLogTracker();
    private static ServiceTracker<LoggerFactory, Logger> loggerTracker = ResourceBundleHelper.openLoggerTracker();
    private static HashSet<String> invalidLocalesLogged = new HashSet();

    private static ServiceTracker<LogService, LogService> openLogTracker() {
        try {
            ServiceTracker st = new ServiceTracker(FrameworkUtil.getBundle(ResourceBundleHelper.class).getBundleContext(), LogService.class, null);
            st.open();
            return st;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static ServiceTracker<LoggerFactory, Logger> openLoggerTracker() {
        try {
            final BundleContext context = FrameworkUtil.getBundle(ResourceBundleHelper.class).getBundleContext();
            ServiceTracker tracker = new ServiceTracker(context, LoggerFactory.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<LoggerFactory, Logger>(){

                public Logger addingService(ServiceReference<LoggerFactory> reference) {
                    LoggerFactory factory = (LoggerFactory)context.getService(reference);
                    if (factory != null) {
                        return factory.getLogger(ResourceBundleHelper.class);
                    }
                    return null;
                }

                public void modifiedService(ServiceReference<LoggerFactory> reference, Logger service) {
                }

                public void removedService(ServiceReference<LoggerFactory> reference, Logger service) {
                    context.ungetService(reference);
                }
            });
            tracker.open();
            return tracker;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static ResourceBundle getResourceBundleForUri(String contributionURI, Locale locale, ResourceBundleProvider provider) {
        URI uri;
        if (contributionURI == null) {
            return null;
        }
        Logger logger = (Logger)loggerTracker.getService();
        try {
            uri = new URI(contributionURI);
        }
        catch (URISyntaxException uRISyntaxException) {
            if (logger != null) {
                logger.error("Invalid contribution URI: {}", (Object)contributionURI);
            }
            return null;
        }
        String bundleName = null;
        Bundle bundle = null;
        String resourcePath = null;
        String classPath = null;
        if (PLATFORM_SCHEMA.equals(uri.getScheme())) {
            bundleName = uri.getPath();
            if (bundleName.startsWith(PLUGIN_SEGMENT)) {
                bundleName = bundleName.substring(PLUGIN_SEGMENT.length());
            } else if (bundleName.startsWith(FRAGMENT_SEGMENT)) {
                bundleName = bundleName.substring(FRAGMENT_SEGMENT.length());
            }
            resourcePath = "";
            if (bundleName.contains(PATH_SEPARATOR)) {
                resourcePath = bundleName.substring(bundleName.indexOf(PATH_SEPARATOR) + 1);
                bundleName = bundleName.substring(0, bundleName.indexOf(PATH_SEPARATOR));
            }
        } else if (BUNDLECLASS_SCHEMA.equals(uri.getScheme())) {
            if (uri.getAuthority() == null && logger != null) {
                logger.error("Failed to get bundle for: {}", (Object)contributionURI);
            }
            bundleName = uri.getAuthority();
            if (uri.getPath() != null && !uri.getPath().isEmpty()) {
                classPath = uri.getPath().substring(1);
            } else if (logger != null) {
                logger.error("Called with invalid contribution URI: {}", (Object)contributionURI);
            }
        }
        ResourceBundle result = null;
        if (bundleName != null && (bundle = ResourceBundleHelper.getBundleForName(bundleName)) != null) {
            if (resourcePath == null && classPath != null) {
                try {
                    Class resourceBundleClass = bundle.loadClass(classPath);
                    result = ResourceBundleHelper.getEquinoxResourceBundle(classPath, locale, resourceBundleClass.getClassLoader());
                }
                catch (Exception e) {
                    if (logger != null) {
                        logger.error("Failed to load specified ResourceBundle: {}", (Object)contributionURI, (Object)e);
                    }
                }
            } else {
                result = resourcePath != null && !resourcePath.isEmpty() ? ResourceBundleHelper.getEquinoxResourceBundle(resourcePath.replace('.', '/'), locale, bundle) : provider.getResourceBundle(bundle, locale.toString());
            }
        }
        return result;
    }

    public static ResourceBundle getEquinoxResourceBundle(String baseName, Locale locale, ClassLoader loader) {
        ResourceBundle resourceBundle = null;
        String equinoxLocale = ResourceBundleHelper.getEquinoxRootLocale();
        if (!equinoxLocale.isEmpty() && locale.toString().startsWith(equinoxLocale)) {
            try {
                resourceBundle = ResourceBundle.getBundle(baseName, locale, loader, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT));
            }
            catch (MissingResourceException missingResourceException) {}
            if (resourceBundle == null) {
                try {
                    resourceBundle = ResourceBundle.getBundle(baseName, Locale.getDefault(), loader, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT));
                }
                catch (MissingResourceException missingResourceException) {}
            }
        } else {
            try {
                resourceBundle = ResourceBundle.getBundle(baseName, locale, loader);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return resourceBundle;
    }

    public static ResourceBundle getEquinoxResourceBundle(String baseName, Locale locale, Bundle bundle) {
        return ResourceBundleHelper.getEquinoxResourceBundle(baseName, locale, new BundleResourceBundleControl(bundle, true), new BundleResourceBundleControl(bundle, false));
    }

    public static ResourceBundle getEquinoxResourceBundle(String baseName, Locale locale, ResourceBundle.Control withFallback, ResourceBundle.Control withoutFallback) {
        ResourceBundle resourceBundle = null;
        String equinoxLocale = ResourceBundleHelper.getEquinoxRootLocale();
        if (!equinoxLocale.isEmpty() && locale.toString().startsWith(equinoxLocale)) {
            try {
                resourceBundle = ResourceBundle.getBundle(baseName, locale, withoutFallback);
            }
            catch (MissingResourceException missingResourceException) {}
            if (resourceBundle == null) {
                try {
                    resourceBundle = ResourceBundle.getBundle(baseName, Locale.getDefault(), withoutFallback);
                }
                catch (MissingResourceException missingResourceException) {}
            }
        } else {
            try {
                resourceBundle = ResourceBundle.getBundle(baseName, locale, withFallback);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return resourceBundle;
    }

    private static String getEquinoxRootLocale() {
        String root = System.getProperties().getProperty("equinox.root.locale");
        if (root == null) {
            root = "en";
        }
        return root;
    }

    public static Bundle getBundleForName(String bundleName) {
        if (bundleName == null) {
            return null;
        }
        Bundle bundle = FrameworkUtil.getBundle(ResourceBundleHelper.class);
        BundleContext context = bundle == null ? null : bundle.getBundleContext();
        Bundle[] bundles = context.getBundles();
        if (bundles == null) {
            return null;
        }
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle localBundle = bundleArray[n2];
            if (bundleName.equals(localBundle.getSymbolicName()) && (localBundle.getState() & 3) == 0) {
                return localBundle;
            }
            ++n2;
        }
        return null;
    }

    public static Locale toLocale(String str) {
        return ResourceBundleHelper.toLocale(str, Locale.getDefault());
    }

    public static Locale toLocale(String localeString, Locale defaultLocale) {
        Logger logger = (Logger)loggerTracker.getService();
        if (localeString == null) {
            if (logger != null) {
                logger.error("Given locale String is null - Default Locale will be used instead.");
            }
            return defaultLocale;
        }
        String language = "";
        String country = "";
        String variant = "";
        String[] localeParts = localeString.split("_");
        if (localeParts.length == 0 || localeParts.length > 3 || localeParts.length == 1 && localeParts[0].isEmpty()) {
            ResourceBundleHelper.logInvalidFormat(localeString, logger);
            return defaultLocale;
        }
        if (!localeParts[0].isEmpty() && !localeParts[0].matches("[a-zA-Z]{2,8}")) {
            ResourceBundleHelper.logInvalidFormat(localeString, logger);
            return defaultLocale;
        }
        language = localeParts[0];
        if (localeParts.length > 1) {
            if (!localeParts[1].isEmpty() && !localeParts[1].matches("[a-zA-Z]{2}|[0-9]{3}")) {
                if (!language.isEmpty()) {
                    if (logger != null) {
                        logger.error("Invalid locale format: {} - Only language part will be used to create the Locale.", (Object)localeString);
                    }
                    return new Locale(language);
                }
                ResourceBundleHelper.logInvalidFormat(localeString, logger);
                return defaultLocale;
            }
            country = localeParts[1];
        }
        if (localeParts.length == 3) {
            if (localeParts[2].isEmpty()) {
                if (logger != null) {
                    logger.error("Invalid locale format: {} - Only language and country part will be used to create the Locale.", (Object)localeString);
                }
                return new Locale(language, country);
            }
            variant = localeParts[2];
        }
        return new Locale(language, country, variant);
    }

    static void logInvalidFormat(String str, Logger log) {
        if (log != null && !invalidLocalesLogged.contains(str)) {
            invalidLocalesLogged.add(str);
            log.error("Invalid locale format: {} - Default Locale will be used instead.", (Object)str);
        }
    }

    @Deprecated
    public static LogService getLogService() {
        return (LogService)logTracker.getService();
    }

    static class BundleResourceBundleControl
    extends ResourceBundle.Control {
        private final boolean useFallback;
        private final Bundle osgiBundle;

        public BundleResourceBundleControl(Bundle osgiBundle, boolean useFallback) {
            this.osgiBundle = osgiBundle;
            this.useFallback = useFallback;
        }

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String bundleName = this.toBundleName(baseName, locale);
            PropertyResourceBundle bundle = null;
            if ("java.properties".equals(format)) {
                String resourceName = this.toResourceName(bundleName, "properties");
                InputStream stream = null;
                try {
                    stream = AccessController.doPrivileged(() -> {
                        URLConnection connection;
                        InputStream is = null;
                        URL url = this.osgiBundle.getEntry(resourceName);
                        if (url != null && (connection = url.openConnection()) != null) {
                            connection.setUseCaches(false);
                            is = connection.getInputStream();
                        }
                        return is;
                    });
                }
                catch (PrivilegedActionException e) {
                    throw (IOException)e.getException();
                }
                if (stream != null) {
                    try {
                        bundle = new PropertyResourceBundle(stream);
                    }
                    finally {
                        stream.close();
                    }
                }
            } else {
                throw new IllegalArgumentException("unknown format: " + format);
            }
            return bundle;
        }

        @Override
        public List<String> getFormats(String baseName) {
            return FORMAT_PROPERTIES;
        }

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            return this.useFallback ? super.getFallbackLocale(baseName, locale) : null;
        }
    }
}

