/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.data.internal.core.common;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.sqltools.data.internal.core.DataCorePlugin;
import org.eclipse.datatools.sqltools.data.internal.core.common.IColumnDataAccessor;
import org.eclipse.datatools.sqltools.data.internal.core.common.data.DataDeserializer;
import org.eclipse.datatools.sqltools.data.internal.core.common.data.DataSerializer;
import org.eclipse.datatools.sqltools.data.internal.core.common.data.PreparedStatementWriter;
import org.eclipse.datatools.sqltools.data.internal.core.common.data.ResultSetReader;

public class DefaultColumnDataAccessor
implements IColumnDataAccessor {
    protected Column sqlCol;
    protected int lobLimit = RDBCorePlugin.getDefault().getPluginPreferences().getInt("OUTPUT_PREFERENCE_MAX_LOB_LENGTH");

    public DefaultColumnDataAccessor() {
        if (this.lobLimit <= 0) {
            this.lobLimit = -1;
        }
    }

    @Override
    public void initialize(Column sqlCol) {
        this.sqlCol = sqlCol;
    }

    @Override
    public String getSelectExpr() {
        String colName = this.sqlCol.getName();
        Connection conn = ((ICatalogObject)this.sqlCol.getTable()).getConnection();
        colName = DataCorePlugin.quoteIdentifier(conn, colName);
        return colName;
    }

    @Override
    public Object read(ResultSet rs, int col, int type, boolean snippet) throws SQLException, IOException {
        return ResultSetReader.read(rs, col, snippet ? this.lobLimit : -1);
    }

    @Override
    public boolean isSnippet(Object val, int type) {
        if (val == null) {
            return false;
        }
        if (type == 2004) {
            return ((byte[])val).length == this.lobLimit;
        }
        if (type == 2005) {
            return ((String)val).length() == this.lobLimit;
        }
        return false;
    }

    @Override
    public String getValuesExpr(Object val) {
        return "?";
    }

    @Override
    public String[] writeValuesExprArgs(PreparedStatement pst, int start, Object val, int type) throws SQLException, IOException {
        PreparedStatementWriter.write(pst, start, type, val);
        return new String[]{this.argString(this.getLabel(val, type), type)};
    }

    @Override
    public String getSetAss(Object val) {
        return String.valueOf(this.getQuotedColumnName()) + "=?";
    }

    @Override
    public String[] writeSetAssArgs(PreparedStatement pst, int start, Object val, int type) throws SQLException, IOException {
        PreparedStatementWriter.write(pst, start, type, val);
        return new String[]{this.argString(this.getLabel(val, type), type)};
    }

    @Override
    public String getWhereCond(Object val) {
        String s = this.getQuotedColumnName();
        s = val == null ? String.valueOf(s) + " is null" : String.valueOf(s) + "=?";
        return s;
    }

    @Override
    public String[] writeWhereCondArgs(PreparedStatement pst, int start, Object val, int type) throws SQLException, IOException {
        if (val != null) {
            PreparedStatementWriter.write(pst, start, type, val);
            return new String[]{this.argString(this.getLabel(val, type), type)};
        }
        return new String[0];
    }

    protected String getQuotedColumnName() {
        Database db = this.sqlCol.getTable().getSchema().getCatalog() != null ? this.sqlCol.getTable().getSchema().getCatalog().getDatabase() : this.sqlCol.getTable().getSchema().getDatabase();
        return DataCorePlugin.quoteIdentifier(db, this.sqlCol.getName());
    }

    protected String argString(String arg, int type) {
        String s = arg;
        if (s == null) {
            return "null";
        }
        if (s.length() > 20) {
            s = String.valueOf(s.substring(0, 20)) + "...";
        }
        if (DataSerializer.needsQuote(type)) {
            s = "'" + s + "'";
        }
        return s;
    }

    @Override
    public String getLabel(Object val, int type) {
        return this.serialize(val, type);
    }

    @Override
    public String serialize(Object val, int type) {
        return DataSerializer.serialize(val, type);
    }

    @Override
    public Object deserialize(String val, int type) {
        return DataDeserializer.deserialize(val, type);
    }

    @Override
    public boolean supportsInlineEdit() {
        return true;
    }
}

