/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.deltaddl;

import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinitionRegistryImpl;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlScript;
import org.eclipse.datatools.enablement.sybase.deltaddl.ConstraintDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.SybaseDeltaDdlGeneration;
import org.eclipse.datatools.modelbase.sql.constraints.Constraint;
import org.eclipse.datatools.modelbase.sql.constraints.ReferenceConstraint;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ReferenceConstraintDeltaDdlGenProvider
extends ConstraintDeltaDdlGenProvider {
    protected boolean _isRecreated = false;

    @Override
    protected void initProvider() {
        super.initProvider();
        this._isRecreated = false;
    }

    @Override
    protected void getModificationResult(SQLObject e, EStructuralFeature feature, Object oldValue, Object newValue, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script) {
        super.getModificationResult(e, feature, oldValue, newValue, quoteIdentifiers, qualifyNames, fullSyntax, script);
        if (!(e instanceof ReferenceConstraint)) {
            return;
        }
        ReferenceConstraint rc = (ReferenceConstraint)e;
        if (feature.getFeatureID() == 12) {
            Database database = (Database)ContainmentServiceImpl.INSTANCE.getRootElement((EObject)rc);
            DatabaseDefinition def = DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(database);
            DDLGenerator ddlgen = def.getDDLGenerator();
            this.reCreateConstraint(ddlgen, rc, quoteIdentifiers, qualifyNames, fullSyntax, script);
        }
    }

    protected void reCreateConstraint(DDLGenerator ddlgen, ReferenceConstraint rc, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script) {
        if (!this._isRecreated) {
            String newName = rc.getName();
            if (this.isNameChanged((SQLObject)rc)) {
                rc.setName(this.getOldName((SQLObject)rc));
            }
            String originalName = "";
            String newName1 = "";
            if (this._modifyRecordMap.get(rc.eContainer()) != null) {
                List list = (List)this._modifyRecordMap.get(rc.eContainer());
                for (SybaseDeltaDdlGeneration.FeatureChangeRecord featureRecorder : list) {
                    if (featureRecorder.feature.getFeatureID() != 1) continue;
                    originalName = (String)featureRecorder.oldValue;
                    newName1 = (String)featureRecorder.newValue;
                    BaseTable table = (BaseTable)rc.eContainer();
                    table.setName(originalName);
                }
            }
            String[] ddl = ddlgen.dropSQLObjects(new SQLObject[]{rc}, quoteIdentifiers, qualifyNames, null);
            if (newName1.length() != 0) {
                BaseTable table = (BaseTable)rc.eContainer();
                table.setName(newName1);
            }
            int i = 0;
            while (i < ddl.length) {
                script.addAlterTableDropConstraintStatement(ddl[i]);
                ++i;
            }
            rc.setName(newName);
            ddl = ddlgen.createSQLObjects(new SQLObject[]{rc}, quoteIdentifiers, qualifyNames, null);
            i = 0;
            while (i < ddl.length) {
                script.addAlterTableAddConstraintStatement(ddl[i]);
                ++i;
            }
            this._isRecreated = true;
        }
    }

    @Override
    protected boolean needGenerateRenamingDdl(Constraint constraint) {
        if (!(constraint instanceof ReferenceConstraint)) {
            return true;
        }
        ReferenceConstraint rc = (ReferenceConstraint)constraint;
        List list = (List)this._modifyRecordMap.get(rc);
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                SybaseDeltaDdlGeneration.FeatureChangeRecord cr = (SybaseDeltaDdlGeneration.FeatureChangeRecord)list.get(i);
                if (cr.feature.getFeatureID() == 12) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected boolean isNameChanged(SQLObject obj) {
        List list = (List)this._modifyRecordMap.get(obj);
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                SybaseDeltaDdlGeneration.FeatureChangeRecord cr = (SybaseDeltaDdlGeneration.FeatureChangeRecord)list.get(i);
                if (cr.feature.getFeatureID() == 1) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected String getOldName(SQLObject obj) {
        List list = (List)this._modifyRecordMap.get(obj);
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                SybaseDeltaDdlGeneration.FeatureChangeRecord cr = (SybaseDeltaDdlGeneration.FeatureChangeRecord)list.get(i);
                if (cr.feature.getFeatureID() == 1) {
                    return (String)cr.oldValue;
                }
                ++i;
            }
        }
        return obj.getName();
    }
}

