/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import java.util.Stack;

public class ReuseStringBuffer
implements CharSequence {
    protected StringBuffer buffer;
    protected static Stack<ReuseStringBuffer> buffers;

    public static ReuseStringBuffer getBuffer() {
        return ReuseStringBuffer.getBuffer(128);
    }

    public static ReuseStringBuffer getBuffer(String str) {
        ReuseStringBuffer b = ReuseStringBuffer.getBuffer(str.length() + 128);
        b.append(str);
        return b;
    }

    public static synchronized ReuseStringBuffer getBuffer(int capacity) {
        if (buffers == null) {
            buffers = new Stack();
        }
        if (!buffers.empty()) {
            int i = buffers.size() - 1;
            while (i > -1) {
                ReuseStringBuffer b = (ReuseStringBuffer)buffers.elementAt(i);
                if (b.capacity() >= capacity) {
                    buffers.removeElementAt(i);
                    return b;
                }
                --i;
            }
        }
        return new ReuseStringBuffer(capacity);
    }

    public static String toString(ReuseStringBuffer buffer) {
        if (buffers == null) {
            buffers = new Stack();
        }
        String ts = buffer.toString();
        buffer.setLength(0);
        buffers.push(buffer);
        return ts;
    }

    public static void freeBuffer(ReuseStringBuffer buffer) {
        if (buffers == null) {
            buffers = new Stack();
        }
        buffer.setLength(0);
        buffers.push(buffer);
    }

    public ReuseStringBuffer() {
        this(128, 1.5f);
    }

    public ReuseStringBuffer(int capacity) {
        this(capacity, 1.5f);
    }

    public ReuseStringBuffer(String str) {
        this(str.length() + 128);
        this.buffer.append(str);
    }

    public ReuseStringBuffer(float expansionFactor) {
        this(128);
    }

    public ReuseStringBuffer(int capacity, float expansionFactor) {
        this.buffer = new StringBuffer(capacity);
    }

    public ReuseStringBuffer(String str, float expansionFactor) {
        this(str.length() + 128);
        this.buffer.append(str);
    }

    @Override
    public int length() {
        return this.buffer.length();
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public synchronized void ensureCapacity(int minimumCapacity) {
        this.buffer.ensureCapacity(minimumCapacity);
    }

    public synchronized void setLength(int newLength) {
        this.buffer.setLength(newLength);
    }

    @Override
    public synchronized char charAt(int index) {
        return this.buffer.charAt(index);
    }

    public synchronized void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        this.buffer.getChars(srcBegin, srcEnd, dst, dstBegin);
    }

    public synchronized void setCharAt(int index, char ch) {
        this.buffer.setCharAt(index, ch);
    }

    public synchronized ReuseStringBuffer append(Object obj) {
        this.buffer.append(obj);
        return this;
    }

    public synchronized ReuseStringBuffer append(String str) {
        this.buffer.append(str);
        return this;
    }

    public synchronized ReuseStringBuffer append(StringBuffer sb) {
        this.buffer.append(sb);
        return this;
    }

    public synchronized ReuseStringBuffer append(ReuseStringBuffer sb) {
        if (sb == null) {
            this.buffer.append("null");
        } else {
            this.buffer.append(sb.toString());
        }
        return this;
    }

    public synchronized ReuseStringBuffer append(char[] str) {
        this.buffer.append(str);
        return this;
    }

    public synchronized ReuseStringBuffer append(char[] str, int offset, int len) {
        this.buffer.append(str, offset, len);
        return this;
    }

    public synchronized ReuseStringBuffer append(boolean b) {
        this.buffer.append(b);
        return this;
    }

    public synchronized ReuseStringBuffer append(char c) {
        this.buffer.append(c);
        return this;
    }

    public synchronized ReuseStringBuffer append(int i) {
        this.buffer.append(i);
        return this;
    }

    public synchronized ReuseStringBuffer append(long l) {
        this.buffer.append(l);
        return this;
    }

    public synchronized ReuseStringBuffer append(float f) {
        this.buffer.append(f);
        return this;
    }

    public synchronized ReuseStringBuffer append(double d) {
        this.buffer.append(d);
        return this;
    }

    public synchronized ReuseStringBuffer delete(int start, int end) {
        this.buffer.delete(start, end);
        return this;
    }

    public synchronized ReuseStringBuffer deleteCharAt(int index) {
        this.buffer.deleteCharAt(index);
        return this;
    }

    public synchronized ReuseStringBuffer replace(int start, int end, String str) {
        this.buffer.replace(start, end, str);
        return this;
    }

    public synchronized String substring(int start) {
        return this.buffer.substring(start);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.buffer.substring(start, end);
    }

    public synchronized String substring(int start, int end) {
        return this.buffer.substring(start, end);
    }

    public synchronized ReuseStringBuffer insert(int index, char[] str, int offset, int len) {
        this.buffer.insert(index, str, offset, len);
        return this;
    }

    public synchronized ReuseStringBuffer insert(int offset, Object obj) {
        this.buffer.insert(offset, obj);
        return this;
    }

    public synchronized ReuseStringBuffer insert(int offset, String str) {
        this.buffer.insert(offset, str);
        return this;
    }

    public synchronized ReuseStringBuffer insert(int offset, char[] str) {
        this.buffer.insert(offset, str);
        return this;
    }

    public ReuseStringBuffer insert(int offset, boolean b) {
        this.buffer.insert(offset, b);
        return this;
    }

    public synchronized ReuseStringBuffer insert(int offset, char c) {
        this.buffer.insert(offset, c);
        return this;
    }

    public ReuseStringBuffer insert(int offset, int i) {
        this.buffer.insert(offset, i);
        return this;
    }

    public ReuseStringBuffer insert(int offset, long l) {
        this.buffer.insert(offset, l);
        return this;
    }

    public ReuseStringBuffer insert(int offset, float f) {
        this.buffer.insert(offset, f);
        return this;
    }

    public ReuseStringBuffer insert(int offset, double d) {
        this.buffer.insert(offset, d);
        return this;
    }

    public int indexOf(String str) {
        return this.buffer.indexOf(str);
    }

    public synchronized int indexOf(String str, int fromIndex) {
        return this.buffer.indexOf(str, fromIndex);
    }

    public synchronized int lastIndexOf(String str) {
        return this.buffer.lastIndexOf(str);
    }

    public synchronized int lastIndexOf(String str, int fromIndex) {
        return this.buffer.lastIndexOf(str, fromIndex);
    }

    public synchronized ReuseStringBuffer reverse() {
        this.buffer.reverse();
        return this;
    }

    @Override
    public String toString() {
        return this.buffer.toString();
    }
}

