/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.datatools.enablement.ibm.IBMPluginActivator;
import org.eclipse.datatools.enablement.ibm.catalog.util.CatalogLoadUtil;
import org.eclipse.datatools.enablement.ibm.util.PRSDatabaseLoader;
import org.eclipse.datatools.enablement.ibm.util.PRSDebug;
import org.eclipse.datatools.enablement.ibm.util.PRSPersistenceUtility;
import org.eclipse.datatools.enablement.ibm.util.PRSQueryInfo;
import org.eclipse.datatools.enablement.ibm.util.SliceKey;

public class PRSSliceInfo {
    private static int writeRowCount = 0;
    private static int readRowCount = 0;
    private int reloadCount = 0;
    private static int nextSerialNumber = 0;
    private int serialNumber;
    private final PRSQueryInfo qinfo;
    private final SliceKey slicekey;
    private long byteOffset = -1L;
    private int rowOffset = -1;
    private final List<Object[]> rowBuffer = new ArrayList<Object[]>();
    private boolean complete = false;
    private int size = -1;
    private boolean needsFlush = true;
    private PRSDatabaseLoader dbloader;

    public PRSSliceInfo(PRSQueryInfo qinfo, SliceKey slicekey) {
        this.serialNumber = nextSerialNumber++;
        this.qinfo = qinfo;
        this.slicekey = slicekey;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(int serialNumber) {
        this.serialNumber = serialNumber;
        if (serialNumber >= nextSerialNumber) {
            nextSerialNumber = serialNumber + 1;
        }
    }

    public void setLoader(PRSDatabaseLoader dbloader) {
        if (this.dbloader == null && this.rowBuffer.isEmpty()) {
            this.dbloader = dbloader;
        }
    }

    public PRSDatabaseLoader getLoader() {
        return this.dbloader;
    }

    public static PRSSliceInfo loadSavedSlice(PRSQueryInfo qinfo, String line) {
        StringTokenizer toker = new StringTokenizer(line, "|");
        int serialNumber = PRSPersistenceUtility.getIntToken(toker);
        long byteOffset = PRSPersistenceUtility.getLongToken(toker);
        int rowOffset = PRSPersistenceUtility.getIntToken(toker);
        int size = PRSPersistenceUtility.getIntToken(toker);
        String keystr = PRSPersistenceUtility.getStringToken(toker);
        SliceKey slicekey = new SliceKey(SliceKey.extractFilterValues(keystr));
        PRSSliceInfo slice = new PRSSliceInfo(qinfo, slicekey);
        slice.setSerialNumber(serialNumber);
        slice.byteOffset = byteOffset;
        slice.rowOffset = rowOffset;
        slice.size = size;
        slice.needsFlush = false;
        return slice;
    }

    public PRSQueryInfo getQueryInfo() {
        return this.qinfo;
    }

    public SliceKey getSliceKey() {
        return this.slicekey;
    }

    public long getDataOffset() {
        return this.byteOffset;
    }

    public void setDataOffset(long offset) {
        this.byteOffset = offset;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isComplete() {
        List<Object[]> list = this.rowBuffer;
        synchronized (list) {
            return this.complete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComplete() {
        List<Object[]> list = this.rowBuffer;
        synchronized (list) {
            this.complete = true;
            this.setLoader(null);
            this.size = this.rowBuffer.size();
        }
    }

    public void waitUntilComplete() {
        while (!this.isComplete()) {
            this.waitForRow();
        }
    }

    public void finish() {
        this.setComplete();
        if (this.size() == 0) {
            this.byteOffset = 0L;
            this.rowOffset = 0;
            this.needsFlush = false;
        } else {
            this.flushSliceData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        List<Object[]> list = this.rowBuffer;
        synchronized (list) {
            if (this.size < 0) {
                this.size = this.rowBuffer.size();
            }
            return this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRow(Object[] row) {
        if (this.isComplete() || this.dbloader == null) {
            return;
        }
        List<Object[]> list = this.rowBuffer;
        synchronized (list) {
            this.rowBuffer.add(row);
            this.size = -1;
            this.needsFlush = true;
        }
    }

    public void waitForRow() {
        this.waitForRow(this.size() + 1);
    }

    public void waitForRow(int rowRequired) {
        while (!this.isComplete() && rowRequired > this.size()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public Object getCurrentValue(int rownum, int index) throws SQLException {
        if (index < 1 || index > this.qinfo.getMetadata().getColumnCount()) {
            throw new SQLException(String.format("Column number %d is out of bounds", index));
        }
        Object[] row = this.getRow(rownum);
        if (row == null) {
            throw new SQLException("No current row " + rownum);
        }
        return row[index - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getRow(int index) {
        if (index < 1) {
            return null;
        }
        List<Object[]> list = this.rowBuffer;
        synchronized (list) {
            if (this.rowBuffer.isEmpty() && this.size > 0) {
                this.reloadRowData();
            }
        }
        this.waitForRow(index);
        list = this.rowBuffer;
        synchronized (list) {
            return index - 1 < this.size() ? this.rowBuffer.get(index - 1) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushSliceData() {
        if (!this.needsFlush || PRSDebug.noFileCache || !PRSDebug.enableFileCache) {
            return;
        }
        if (PRSDebug.traceQueries) {
            System.out.println("Flushing slice q" + this.qinfo.getId());
            System.out.println("  " + this.rowBuffer.size() + " rows" + " total r=" + readRowCount + " w=" + (writeRowCount += this.rowBuffer.size()));
        }
        List<Object[]> list = this.rowBuffer;
        synchronized (list) {
            if (!this.rowBuffer.isEmpty()) {
                PrintWriter pw;
                if (this.byteOffset < 0L) {
                    File dfile = this.qinfo.getDataFile();
                    this.byteOffset = dfile.length();
                }
                if (this.rowOffset < 0) {
                    this.rowOffset = this.qinfo.getNextDataFileRowOffset();
                }
                if ((pw = this.getDataFileWriter()) == null) {
                    this.needsFlush = false;
                    return;
                }
                for (Object[] row : this.rowBuffer) {
                    pw.println(this.rowToPrintString(row));
                }
                CatalogLoadUtil.safeClose(pw);
            }
            this.needsFlush = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadRowData() {
        List<Object[]> list = this.rowBuffer;
        synchronized (list) {
            this.flushSliceData();
            if (PRSDebug.enableFileCache) {
                this.rowBuffer.clear();
            }
        }
    }

    private void reloadRowData() {
        block15: {
            File sfile;
            if (this.size <= 0) {
                return;
            }
            if (!PRSDebug.enableFileCache) {
                if (PRSDebug.traceQueries) {
                    System.out.println(" ERROR! Can't reload slice when file caching is disabled!");
                }
                return;
            }
            if (PRSDebug.traceQueries) {
                ++this.reloadCount;
                System.out.println("Reloading slice q" + this.qinfo.getId());
                System.out.println("  " + this.size + " rows" + " total r=" + (readRowCount += this.size) + " w=" + writeRowCount);
                System.out.println("  " + this.reloadCount + " reloads for this slice");
            }
            if (!this.rowBuffer.isEmpty()) {
                if (this.needsFlush) {
                    return;
                }
                this.rowBuffer.clear();
            }
            if ((sfile = this.qinfo.getDataFile()) == null || !sfile.exists() || !sfile.canRead()) {
                return;
            }
            LineNumberReader lr = null;
            try {
                try {
                    lr = new LineNumberReader(new FileReader(sfile));
                    int count = this.size;
                    String line = this.seekFirstRow(lr);
                    while (count > 0 && line != null) {
                        Object[] row = this.printStringToRow(line);
                        if (row != null) {
                            this.rowBuffer.add(row);
                            line = lr.readLine();
                            --count;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    IBMPluginActivator.log(e);
                    CatalogLoadUtil.safeClose(lr);
                    break block15;
                }
            }
            catch (Throwable throwable) {
                CatalogLoadUtil.safeClose(lr);
                throw throwable;
            }
            CatalogLoadUtil.safeClose(lr);
        }
        if (this.rowBuffer.size() != this.size) {
            this.size = this.rowBuffer.size();
        }
        this.needsFlush = false;
    }

    private String seekFirstRow(LineNumberReader lr) throws IOException {
        String line;
        int rownum;
        if (this.byteOffset > 0L) {
            lr.skip(this.byteOffset);
        }
        do {
            if ((line = lr.readLine()) == null) {
                return null;
            }
            StringTokenizer st = new StringTokenizer(line, "|");
            rownum = PRSPersistenceUtility.getIntToken(st);
            if (rownum <= this.rowOffset) continue;
            return null;
        } while (rownum != this.rowOffset);
        return line;
    }

    public void save(PrintWriter pw) {
        pw.println(this.toPrintString());
    }

    public String toPrintString() {
        StringBuilder sb = new StringBuilder();
        if (this.byteOffset < 0L) {
            this.byteOffset = 0L;
        }
        if (this.rowOffset < 0) {
            this.rowOffset = 0;
        }
        PRSPersistenceUtility.append(sb, this.serialNumber);
        PRSPersistenceUtility.append(sb, this.byteOffset);
        PRSPersistenceUtility.append(sb, this.rowOffset);
        PRSPersistenceUtility.append(sb, this.size());
        PRSPersistenceUtility.append(sb, this.getSliceKey().toString());
        return sb.toString();
    }

    public String rowToPrintString(Object[] row) {
        int numcols = 0;
        try {
            numcols = this.qinfo.getMetadata().getColumnCount();
        }
        catch (SQLException e) {
            IBMPluginActivator.log(e);
        }
        StringBuilder sb = new StringBuilder();
        PRSPersistenceUtility.append(sb, this.qinfo.nextDataFileRowOffset());
        int ii = 0;
        while (ii < numcols) {
            PRSPersistenceUtility.append(sb, row[ii]);
            ++ii;
        }
        return sb.toString();
    }

    public Object[] printStringToRow(String s) {
        int numcols = 0;
        try {
            numcols = this.qinfo.getMetadata().getColumnCount();
        }
        catch (SQLException e) {
            IBMPluginActivator.log(e);
        }
        Object[] row = new Object[numcols];
        StringTokenizer st = new StringTokenizer(s, "|");
        PRSPersistenceUtility.getIntToken(st);
        int ii = 0;
        while (ii < numcols) {
            row[ii] = PRSPersistenceUtility.getToken(st);
            ++ii;
        }
        return row;
    }

    public PrintWriter getDataFileWriter() {
        return PRSPersistenceUtility.openFileForAppend(this.qinfo.getDataFile());
    }
}

