/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.ui.cxx;

import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.cdt.ui.text.IInvocationContext;
import org.eclipse.cdt.ui.text.IProblemLocation;
import org.eclipse.cdt.ui.text.IQuickFixProcessor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public abstract class AbstractCodanCQuickFixProcessor
implements IQuickFixProcessor {
    public boolean hasCorrections(ITranslationUnit unit, int problemId) {
        return problemId == 42;
    }

    public ICCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        if (locations == null || locations.length == 0) {
            return null;
        }
        IProblemLocation loc = locations[0];
        IPath location = context.getTranslationUnit().getLocation();
        IFile astFile = ResourceLookup.selectFileForLocation((IPath)location, (IProject)context.getTranslationUnit().getCProject().getProject());
        IMarker[] markers = astFile.findMarkers(loc.getMarkerType(), false, 1);
        int i = 0;
        while (i < markers.length) {
            IMarker m = markers[i];
            int start = m.getAttribute("charStart", -1);
            if (start == loc.getOffset()) {
                String id = m.getAttribute("id", "");
                return this.getCorrections(context, id, m);
            }
            ++i;
        }
        return null;
    }

    public int getOffset(IMarker marker, IDocument doc) {
        int position;
        int charStart = marker.getAttribute("charStart", -1);
        if (charStart > 0) {
            position = charStart;
        } else {
            int line = marker.getAttribute("lineNumber", -1) - 1;
            try {
                position = doc.getLineOffset(line);
            }
            catch (BadLocationException e) {
                return -1;
            }
        }
        return position;
    }

    public abstract ICCompletionProposal[] getCorrections(IInvocationContext var1, String var2, IMarker var3);
}

