/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.language;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SubExpression {
    private final Object expression;
    private List<SubExpression> subSteps;
    private final String label;

    public SubExpression(Object expression) {
        this(expression, null);
    }

    public SubExpression(Object expression, String label) {
        this.expression = expression;
        this.subSteps = new ArrayList<SubExpression>();
        this.label = label == null || label.length() == 0 ? expression.toString() : label;
    }

    public Object getExpression() {
        return this.expression;
    }

    public void addSubStep(SubExpression subStep) {
        this.subSteps.add(subStep);
    }

    public List<SubExpression> getSubSteps() {
        return Collections.unmodifiableList(this.subSteps);
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return this.getLabel();
    }
}

