/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.schema.sql;

import com.google.gwtorm.jdbc.gen.CodeGenSupport;
import com.google.gwtorm.schema.ColumnModel;
import com.google.gwtorm.schema.sql.SqlDialect;
import com.google.gwtorm.schema.sql.SqlTypeInfo;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public class SqlBooleanTypeInfo
extends SqlTypeInfo {
    @Override
    public String getSqlType(ColumnModel column, SqlDialect dialect) {
        String name = column.getColumnName();
        String t = this.getTrueLiteralValue();
        String f = this.getFalseLiteralValue();
        StringBuilder r = new StringBuilder();
        r.append("CHAR(1)");
        if (column.isNotNull()) {
            r.append(" DEFAULT " + f);
            r.append(" NOT NULL");
        }
        return r.toString();
    }

    @Override
    public String getCheckConstraint(ColumnModel column, SqlDialect dialect) {
        String name = column.getColumnName();
        String t = this.getTrueLiteralValue();
        String f = this.getFalseLiteralValue();
        return " CHECK (" + name + " IN (" + t + "," + f + "))";
    }

    @Override
    protected String getJavaSqlTypeAlias() {
        return "String";
    }

    @Override
    protected int getSqlTypeConstant() {
        return 1;
    }

    public String getTrueValue() {
        return "Y";
    }

    public String getFalseValue() {
        return "N";
    }

    public String getTrueLiteralValue() {
        return "'" + this.getTrueValue() + "'";
    }

    public String getFalseLiteralValue() {
        return "'" + this.getFalseValue() + "'";
    }

    @Override
    public void generatePreparedStatementSet(CodeGenSupport cgs) {
        cgs.pushSqlHandle();
        cgs.pushColumnIndex();
        cgs.pushFieldValue();
        Label useNo = new Label();
        Label end = new Label();
        cgs.mv.visitJumpInsn(153, useNo);
        cgs.mv.visitLdcInsn((Object)this.getTrueValue());
        cgs.mv.visitJumpInsn(167, end);
        cgs.mv.visitLabel(useNo);
        cgs.mv.visitLdcInsn((Object)this.getFalseValue());
        cgs.mv.visitLabel(end);
        cgs.invokePreparedStatementSet(this.getJavaSqlTypeAlias());
    }

    @Override
    public void generateResultSetGet(CodeGenSupport cgs) {
        cgs.fieldSetBegin();
        cgs.mv.visitLdcInsn((Object)this.getTrueValue());
        cgs.pushSqlHandle();
        cgs.pushColumnIndex();
        cgs.invokeResultSetGet(this.getJavaSqlTypeAlias());
        cgs.mv.visitMethodInsn(182, Type.getInternalName(String.class), "equals", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.getType(Object.class)}));
        cgs.fieldSetEnd();
    }
}

