/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable;

import java.util.stream.Stream;
import org.eclipse.collections.api.factory.stack.MutableStackFactory;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.impl.stack.mutable.ArrayStack;

public class MutableStackFactoryImpl
implements MutableStackFactory {
    public static final MutableStackFactory INSTANCE = new MutableStackFactoryImpl();

    public <T> MutableStack<T> empty() {
        return ArrayStack.newStack();
    }

    public <T> MutableStack<T> with(T ... elements) {
        return ArrayStack.newStackWith(elements);
    }

    public <T> MutableStack<T> withAll(Iterable<? extends T> elements) {
        return ArrayStack.newStack(elements);
    }

    public <T> MutableStack<T> fromStream(Stream<? extends T> stream) {
        ArrayStack stack = ArrayStack.newStack();
        stream.forEach(stack::push);
        return stack;
    }

    public <T> MutableStack<T> withReversed(T ... elements) {
        return ArrayStack.newStackFromTopToBottom(elements);
    }

    public <T> MutableStack<T> withAllReversed(Iterable<? extends T> items) {
        return ArrayStack.newStackFromTopToBottom(items);
    }
}

