/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.internal.validators;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.rcptt.core.builder.IQ7ProblemReporter;
import org.eclipse.rcptt.core.builder.Q7ProblemSources;
import org.eclipse.rcptt.core.ecl.parser.EclScannerParser;
import org.eclipse.rcptt.core.ecl.parser.ast.Arg;
import org.eclipse.rcptt.core.ecl.parser.ast.Command;
import org.eclipse.rcptt.core.ecl.parser.ast.Pipeline;
import org.eclipse.rcptt.core.ecl.parser.ast.PipelineArg;
import org.eclipse.rcptt.core.ecl.parser.ast.Script;
import org.eclipse.rcptt.core.ecl.parser.ast.ScriptArg;
import org.eclipse.rcptt.ecl.parser.EclValidator;
import org.eclipse.rcptt.ecl.parser.ScriptErrorStatus;

public class ScriptValidator {
    private static final String GET_PARAM_CMD = "get-param";
    private static final String SET_PARAM_CMD = "set-param";

    public static void validateErrors(String eclCode, IQ7ProblemReporter reporter, IFile element) {
        IStatus status = EclValidator.Instanse.validate(eclCode);
        if (status != null && status instanceof ScriptErrorStatus) {
            ScriptErrorStatus error = (ScriptErrorStatus)status;
            int offset = ScriptValidator.calcOffset(eclCode, error.getLine(), error.getColumn());
            reporter.reportProblem(element, IQ7ProblemReporter.ProblemType.Error, "Syntax error at " + error.getLine() + ":" + (error.getColumn() + 1), error.getLine(), offset, error.getLength(), Q7ProblemSources.ERR_SYNTAX.getSourceId());
        }
    }

    public static void validateWarnings(String eclCode, IQ7ProblemReporter reporter, IFile element) {
        Script script = EclScannerParser.parse((String)eclCode);
        for (Pipeline pipe : script.pipelines) {
            ScriptValidator.validateWarningPipeline(eclCode, pipe, reporter, element);
        }
    }

    private static int calcOffset(String text, int line, int column) {
        int offset = 0;
        int l = 1;
        int col = 0;
        while (l < line) {
            if (text.charAt(offset) == '\n') {
                ++l;
            }
            ++offset;
        }
        while (col < column) {
            if (text.charAt(offset) == '\t') {
                offset += 4;
                col += 4;
                continue;
            }
            ++offset;
            ++col;
        }
        return offset;
    }

    private static TextPosition calcPosition(String text, int offset) {
        int line = 1;
        int col = 0;
        int i = 0;
        while (i < offset) {
            if (text.charAt(i) == '\n') {
                ++line;
                col = 0;
            } else {
                col = text.charAt(i) == '\t' ? (col += 4) : ++col;
            }
            ++i;
        }
        return new TextPosition(line, col);
    }

    private static void validateWarningPipeline(String eclCode, Pipeline pipe, IQ7ProblemReporter reporter, IFile element) {
        for (Command cmd : pipe.commands) {
            TextPosition pos;
            if (cmd.name.text.equals(GET_PARAM_CMD)) {
                pos = ScriptValidator.calcPosition(eclCode, cmd.begin);
                reporter.reportProblem(element, IQ7ProblemReporter.ProblemType.Warning, "Command \"get-param\" is obsolete (use '$' annotation instead) at " + pos.line + ":" + (pos.col + 1), pos.line, cmd.begin, GET_PARAM_CMD.length(), Q7ProblemSources.WARN_OBSOLETE_GETPARAM_CMD.getSourceId());
            } else if (cmd.name.text.equals(SET_PARAM_CMD)) {
                pos = ScriptValidator.calcPosition(eclCode, cmd.begin);
                reporter.reportProblem(element, IQ7ProblemReporter.ProblemType.Warning, "Command \"set-param\" is obsolete (consider switching to parameters context or using ECL commands 'let' or 'global' instead) at " + pos.line + ":" + (pos.col + 1), pos.line, cmd.begin, SET_PARAM_CMD.length(), Q7ProblemSources.WARN_OBSOLETE_SETPARAM_CMD.getSourceId());
            }
            for (Arg arg : cmd.args) {
                if (arg instanceof PipelineArg) {
                    ScriptValidator.validateWarningPipeline(eclCode, ((PipelineArg)arg).pipeline, reporter, element);
                    continue;
                }
                if (!(arg instanceof ScriptArg)) continue;
                for (Pipeline subpipe : ((ScriptArg)arg).script.pipelines) {
                    ScriptValidator.validateWarningPipeline(eclCode, subpipe, reporter, element);
                }
            }
        }
    }

    public static Command findCommand(String eclCode, int offset) {
        Script script = EclScannerParser.parse((String)eclCode);
        for (Pipeline pipe : script.pipelines) {
            Command cmd = ScriptValidator.findCommand(pipe, offset);
            if (cmd == null) continue;
            return cmd;
        }
        return null;
    }

    private static Command findCommand(Pipeline pipe, int offset) {
        for (Command cmd : pipe.commands) {
            if (cmd.begin > offset) {
                return null;
            }
            if (cmd.name.text.equals(GET_PARAM_CMD) && cmd.begin == offset) {
                return cmd;
            }
            for (Arg arg : cmd.args) {
                if (arg.begin > offset) {
                    return null;
                }
                if (arg instanceof PipelineArg) {
                    Command pipeCmd = ScriptValidator.findCommand(((PipelineArg)arg).pipeline, offset);
                    if (pipeCmd == null) continue;
                    return pipeCmd;
                }
                if (!(arg instanceof ScriptArg)) continue;
                for (Pipeline subpipe : ((ScriptArg)arg).script.pipelines) {
                    if (subpipe.begin > offset) {
                        return null;
                    }
                    Command subCmd = ScriptValidator.findCommand(subpipe, offset);
                    if (subCmd == null) continue;
                    return subCmd;
                }
            }
        }
        return null;
    }

    private static class TextPosition {
        int line;
        int col;

        public TextPosition(int line, int col) {
            this.line = line;
            this.col = col;
        }
    }
}

