/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.filesystem.internal.commands;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.Get;
import org.eclipse.rcptt.ecl.dispatch.IScriptletExtension;
import org.eclipse.rcptt.ecl.filesystem.EclFile;
import org.eclipse.rcptt.ecl.filesystem.EclFilesystemPlugin;
import org.eclipse.rcptt.ecl.filesystem.File;
import org.eclipse.rcptt.ecl.filesystem.FileResolver;
import org.eclipse.rcptt.ecl.filesystem.FilesystemFactory;
import org.eclipse.rcptt.ecl.runtime.BoxedValues;
import org.eclipse.rcptt.ecl.runtime.SingleCommandService;

public class GetFromFileService
extends SingleCommandService<Get>
implements IScriptletExtension {
    public GetFromFileService() {
        super(Get.class);
    }

    private static Key parseKey(Object object) {
        Object keyObject = BoxedValues.unbox((Object)object);
        if (keyObject == null) {
            return null;
        }
        if (!(keyObject instanceof String)) {
            return null;
        }
        String keyString = (String)keyObject;
        try {
            return Key.valueOf(Key.class, keyString.toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public boolean canHandle(Command command) {
        if (!(command instanceof Get)) {
            return false;
        }
        Get get = (Get)command;
        if (!(get.getInput() instanceof File)) {
            return false;
        }
        return GetFromFileService.parseKey(get.getKey()) != null;
    }

    protected Object serviceTyped(Get command) throws InterruptedException, CoreException {
        Key key = GetFromFileService.parseKey(command.getKey());
        if (key == null) {
            throw new CoreException((IStatus)EclFilesystemPlugin.createError("Invalid key: %s", command.getKey()));
        }
        String uriString = ((File)command.getInput()).getUri();
        URI uri = URI.create(uriString);
        EclFile input = FileResolver.resolve(uri);
        return key.handle(input);
    }

    static enum Key {
        EXISTS{

            @Override
            Object handle(EclFile file) {
                return file.exists();
            }
        }
        ,
        CHILDREN{

            @Override
            Object handle(EclFile file) throws CoreException {
                Collection<? extends EclFile> files = file.getChildren();
                ArrayList<File> rv = new ArrayList<File>();
                for (EclFile eclFile : files) {
                    File item = FilesystemFactory.eINSTANCE.createFile();
                    item.setUri(eclFile.toURI().toString());
                    rv.add(item);
                }
                return rv;
            }
        }
        ,
        NAME{

            @Override
            Object handle(EclFile file) {
                return file.getName();
            }
        }
        ,
        ISDIRECTORY{

            @Override
            Object handle(EclFile file) {
                return file.isDirectory();
            }
        };


        abstract Object handle(EclFile var1) throws CoreException;
    }
}

