/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.commons.ISelectionActionsHandler;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public abstract class SelectionAction
extends Action {
    private final ISelectionActionsHandler handler;

    public SelectionAction(ISelectionActionsHandler handler, String text, String actionID, ImageDescriptor image, ImageDescriptor imageDisabled) {
        super(text, image);
        this.setDisabledImageDescriptor(imageDisabled);
        this.setActionDefinitionId(actionID);
        this.handler = handler;
    }

    public ISelectionActionsHandler getSelectionHandler() {
        return this.handler;
    }

    public void update() {
        this.setEnabled(this.isEnabled());
    }

    public static class CopyAction
    extends SelectionAction {
        public CopyAction(ISelectionActionsHandler handler) {
            super(handler, Messages.SelectionAction_Copy, ActionFactory.COPY.getCommandId(), PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"), PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        }

        public boolean isEnabled() {
            return this.getSelectionHandler().canCopy();
        }

        public void run() {
            if (this.isEnabled()) {
                this.getSelectionHandler().copy();
            }
        }
    }

    public static class CutAction
    extends SelectionAction {
        public CutAction(ISelectionActionsHandler handler) {
            super(handler, Messages.SelectionAction_Cut, ActionFactory.CUT.getCommandId(), PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_CUT"), PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        }

        public boolean isEnabled() {
            return this.getSelectionHandler().canCut();
        }

        public void run() {
            if (this.isEnabled()) {
                this.getSelectionHandler().cut();
            }
        }
    }

    public static class PasteAction
    extends SelectionAction {
        public PasteAction(ISelectionActionsHandler handler) {
            super(handler, Messages.SelectionAction_Paste, ActionFactory.PASTE.getCommandId(), PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"), PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        }

        public boolean isEnabled() {
            return this.getSelectionHandler().canPaste();
        }

        public void run() {
            if (this.isEnabled()) {
                this.getSelectionHandler().paste();
            }
        }
    }

    public static class RemoveAction
    extends SelectionAction {
        public RemoveAction(ISelectionActionsHandler handler) {
            super(handler, Messages.SelectionAction_Remove, ActionFactory.DELETE.getCommandId(), PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"), PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        }

        public boolean isEnabled() {
            return this.getSelectionHandler().canRemove();
        }

        public void run() {
            if (this.isEnabled()) {
                this.getSelectionHandler().handleRemove();
            }
        }
    }
}

