/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.commands.internal.HandlerServiceImpl;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.CommandNotMappedException;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.actions.CommandAction;
import org.eclipse.ui.internal.handlers.ActionDelegateHandlerProxy;
import org.eclipse.ui.internal.handlers.E4HandlerProxy;
import org.eclipse.ui.internal.handlers.IActionCommandMappingService;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.services.IServiceLocator;

public final class ContributedAction
extends CommandAction {
    private IEvaluationContext appContext;
    private IHandler partHandler;
    private boolean localHandler = false;
    private IPartListener partListener;

    public ContributedAction(IServiceLocator locator, IConfigurationElement element) throws CommandNotMappedException {
        String actionId = element.getAttribute("id");
        String commandId = element.getAttribute("definitionId");
        String contributionId = null;
        if (commandId == null) {
            Object obj = element.getParent();
            if (obj instanceof IConfigurationElement && (contributionId = ((IConfigurationElement)obj).getAttribute("id")) == null) {
                throw new CommandNotMappedException("Action " + actionId + " configuration element invalid");
            }
            IActionCommandMappingService mapping = locator.getService(IActionCommandMappingService.class);
            if (mapping == null) {
                throw new CommandNotMappedException("No action mapping service available");
            }
            commandId = mapping.getCommandId(mapping.getGeneratedCommandId(contributionId, actionId));
        }
        if (commandId == null) {
            throw new CommandNotMappedException("Action " + actionId + " in contribution " + contributionId + " not mapped to a command");
        }
        this.init(locator, commandId, null);
        if (locator instanceof IWorkbenchPartSite) {
            this.updateSiteAssociations((IWorkbenchPartSite)locator, commandId, actionId, element);
        }
        this.setId(actionId);
    }

    private void updateSiteAssociations(IWorkbenchPartSite site, String commandId, String actionId, IConfigurationElement element) {
        IWorkbenchLocationService wls = (IWorkbenchLocationService)site.getService(IWorkbenchLocationService.class);
        IWorkbench workbench = wls.getWorkbench();
        IWorkbenchWindow window = wls.getWorkbenchWindow();
        IHandlerService serv = (IHandlerService)workbench.getService(IHandlerService.class);
        this.appContext = new EvaluationContext(serv.getCurrentState(), (Object)Collections.EMPTY_LIST);
        this.appContext.addVariable("selection", (Object)StructuredSelection.EMPTY);
        this.appContext.addVariable("activePart", (Object)site.getPart());
        this.appContext.addVariable("activePartId", (Object)site.getId());
        this.appContext.addVariable("activeSite", (Object)site);
        if (site instanceof IEditorSite) {
            this.appContext.addVariable("activeEditor", (Object)site.getPart());
            this.appContext.addVariable("activeEditorId", (Object)site.getId());
        }
        this.appContext.addVariable("activeWorkbenchWindow", (Object)window);
        this.appContext.addVariable("activeWorkbenchWindowShell", (Object)window.getShell());
        this.partHandler = this.lookUpHandler(site, commandId);
        if (this.partHandler == null) {
            this.localHandler = true;
            this.partHandler = new ActionDelegateHandlerProxy(element, "class", actionId, this.getParameterizedCommand(), site.getWorkbenchWindow(), null, null, null);
        }
        if (site instanceof MultiPageEditorSite) {
            IHandlerService siteServ = (IHandlerService)site.getService(IHandlerService.class);
            siteServ.activateHandler(commandId, this.partHandler);
        }
        if (this.getParameterizedCommand() != null) {
            this.getParameterizedCommand().getCommand().removeCommandListener(this.getCommandListener());
        }
        site.getPage().addPartListener(this.getPartListener());
    }

    private IHandler lookUpHandler(IServiceLocator site, String commandId) {
        HandlerServiceImpl impl = (HandlerServiceImpl)site.getService(EHandlerService.class);
        IEclipseContext c = impl.getContext();
        Object h = HandlerServiceImpl.lookUpHandler((IEclipseContext)c, (String)commandId);
        if (h instanceof E4HandlerProxy) {
            return ((E4HandlerProxy)h).getHandler();
        }
        return null;
    }

    @Override
    public void runWithEvent(Event event) {
        if (this.partHandler != null && this.getParameterizedCommand() != null) {
            IHandler oldHandler = this.getParameterizedCommand().getCommand().getHandler();
            try {
                try {
                    this.getParameterizedCommand().getCommand().setHandler(this.partHandler);
                    this.getParameterizedCommand().executeWithChecks((Object)event, (Object)this.appContext);
                }
                catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException throwable) {
                    this.getParameterizedCommand().getCommand().setHandler(oldHandler);
                }
            }
            finally {
                this.getParameterizedCommand().getCommand().setHandler(oldHandler);
            }
        } else {
            super.runWithEvent(event);
        }
    }

    public boolean isEnabled() {
        if (this.partHandler != null) {
            if (this.partHandler instanceof IHandler2) {
                ((IHandler2)this.partHandler).setEnabled((Object)this.appContext);
            }
            return this.partHandler.isEnabled();
        }
        return false;
    }

    private IPartListener getPartListener() {
        if (this.partListener == null) {
            IWorkbenchPartSite site = (IWorkbenchPartSite)this.appContext.getVariable("activeSite");
            final IWorkbenchPart currentPart = site instanceof MultiPageEditorSite ? ((MultiPageEditorSite)site).getMultiPageEditor() : site.getPart();
            this.partListener = new IPartListener(){

                @Override
                public void partActivated(IWorkbenchPart part) {
                }

                @Override
                public void partBroughtToTop(IWorkbenchPart part) {
                }

                @Override
                public void partClosed(IWorkbenchPart part) {
                    if (part == currentPart) {
                        ContributedAction.this.disposeAction();
                    }
                }

                @Override
                public void partDeactivated(IWorkbenchPart part) {
                }

                @Override
                public void partOpened(IWorkbenchPart part) {
                }
            };
        }
        return this.partListener;
    }

    private void disposeAction() {
        if (this.appContext != null) {
            if (this.localHandler) {
                this.partHandler.dispose();
            }
            if (this.partListener != null) {
                IWorkbenchPartSite site = (IWorkbenchPartSite)this.appContext.getVariable("activeSite");
                site.getPage().removePartListener(this.partListener);
                this.partListener = null;
            }
            this.appContext = null;
            this.partHandler = null;
        }
        this.dispose();
    }
}

