/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.services.about;

import java.io.PrintWriter;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.e4.core.internal.services.about.AboutMessages;
import org.eclipse.e4.core.services.about.ISystemInformation;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(service={ISystemInformation.class})
@ISystemInformation.Section(value="section.installed.features")
public class InstalledFeatures
implements ISystemInformation {
    private final List<IBundleGroupProvider> providers = new ArrayList<IBundleGroupProvider>();

    @Override
    public void append(PrintWriter writer) {
        LinkedList groups = new LinkedList();
        this.providers.forEach(p -> Arrays.stream(p.getBundleGroups()).forEach(groups::add));
        groups.stream().sorted(this.createComparator()).forEach(i -> writer.println(String.format(AboutMessages.featuresInfoFormat, i.getIdentifier(), i.getVersion(), i.getName())));
    }

    private Comparator<IBundleGroup> createComparator() {
        Collator collator = Collator.getInstance(Locale.getDefault());
        return (o1, o2) -> {
            String id2;
            String id1 = o1.getIdentifier();
            if (!id1.equals(id2 = o2.getIdentifier())) {
                return collator.compare(id1, id2);
            }
            return collator.compare(o1.getName(), o2.getName());
        };
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    public void bindBundleProvider(IBundleGroupProvider provider) {
        this.providers.add(provider);
    }

    public void unbindBundleProvider(IBundleGroupProvider provider) {
        this.providers.remove(provider);
    }
}

