/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;

public class CollectAction
extends ProvisioningAction {
    public static final String ACTION_COLLECT = "collect";

    public IStatus execute(Map<String, Object> parameters) {
        IProfile profile = (IProfile)parameters.get("profile");
        IProvisioningAgent agent = (IProvisioningAgent)parameters.get("agent");
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        try {
            List<IArtifactRequest> requests = this.collect(agent, iu, profile);
            if (!requests.isEmpty()) {
                Collection artifactRequests = (Collection)parameters.get("artifactRequests");
                artifactRequests.add((IArtifactRequest[])requests.toArray(IArtifactRequest[]::new));
            }
        }
        catch (ProvisionException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(Map<String, Object> parameters) {
        return Status.OK_STATUS;
    }

    private List<IArtifactRequest> collect(IProvisioningAgent agent, IInstallableUnit installableUnit, IProfile profile) throws ProvisionException {
        Collection toDownload = installableUnit.getArtifacts();
        if (toDownload == null || toDownload.isEmpty()) {
            return List.of();
        }
        IFileArtifactRepository destination = Util.getDownloadCacheRepo(agent);
        IArtifactRepositoryManager manager = Util.getArtifactRepositoryManager(agent);
        ArrayList<IArtifactRequest> requests = new ArrayList<IArtifactRequest>(toDownload.size());
        for (IArtifactKey key : toDownload) {
            requests.add(manager.createMirrorRequest(key, (IArtifactRepository)destination, null, null, profile.getProperty("org.eclipse.equinox.p2.stats.parameters")));
        }
        return requests;
    }
}

