/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.bindings;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Objects;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.jface.bindings.TriggerSequence;

public abstract class Binding {
    private static final int HASH_CODE_NOT_COMPUTED = -1;
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL = Binding.class.getName().hashCode();
    public static final int SYSTEM = 0;
    public static final int USER = 1;
    private final ParameterizedCommand command;
    private final String contextId;
    private transient int hashCode = -1;
    private final String locale;
    private final String platform;
    private final String schemeId;
    protected transient String string = null;
    private final int type;

    protected Binding(ParameterizedCommand command, String schemeId, String contextId, String locale, String platform, String windowManager, int type) {
        if (schemeId == null) {
            throw new NullPointerException("The scheme cannot be null");
        }
        if (contextId == null) {
            throw new NullPointerException("The context cannot be null");
        }
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("The type must be SYSTEM or USER");
        }
        this.command = command;
        this.schemeId = schemeId.intern();
        this.contextId = contextId.intern();
        this.locale = locale == null ? null : locale.intern();
        this.platform = platform == null ? null : platform.intern();
        this.type = type;
    }

    final boolean deletes(Binding binding) {
        boolean deletes = true;
        deletes &= Objects.equals(this.getContextId(), binding.getContextId());
        deletes &= Objects.equals(this.getTriggerSequence(), binding.getTriggerSequence());
        if (this.getLocale() != null) {
            deletes &= !Objects.equals(this.getLocale(), binding.getLocale());
        }
        if (this.getPlatform() != null) {
            deletes &= !Objects.equals(this.getPlatform(), binding.getPlatform());
        }
        deletes &= binding.getType() == 0;
        return deletes &= Objects.equals(this.getParameterizedCommand(), null);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object object) {
        void binding;
        if (this == object) {
            return true;
        }
        if (!(object instanceof Binding)) {
            return false;
        }
        Binding binding2 = (Binding)object;
        if (!Objects.equals(this.getParameterizedCommand(), binding.getParameterizedCommand())) {
            return false;
        }
        if (!Objects.equals(this.getContextId(), binding.getContextId())) {
            return false;
        }
        if (!Objects.equals(this.getTriggerSequence(), binding.getTriggerSequence())) {
            return false;
        }
        if (!Objects.equals(this.getLocale(), binding.getLocale())) {
            return false;
        }
        if (!Objects.equals(this.getPlatform(), binding.getPlatform())) {
            return false;
        }
        if (!Objects.equals(this.getSchemeId(), binding.getSchemeId())) {
            return false;
        }
        return this.getType() == binding.getType();
    }

    public final ParameterizedCommand getParameterizedCommand() {
        return this.command;
    }

    public final String getContextId() {
        return this.contextId;
    }

    public final String getLocale() {
        return this.locale;
    }

    public final String getPlatform() {
        return this.platform;
    }

    public final String getSchemeId() {
        return this.schemeId;
    }

    public abstract TriggerSequence getTriggerSequence();

    public final int getType() {
        return this.type;
    }

    public final int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = HASH_INITIAL;
            this.hashCode = this.hashCode * 89 + Objects.hashCode(this.getParameterizedCommand());
            this.hashCode = this.hashCode * 89 + Objects.hashCode(this.getContextId());
            this.hashCode = this.hashCode * 89 + Objects.hashCode(this.getTriggerSequence());
            this.hashCode = this.hashCode * 89 + Objects.hashCode(this.getLocale());
            this.hashCode = this.hashCode * 89 + Objects.hashCode(this.getPlatform());
            this.hashCode = this.hashCode * 89 + Objects.hashCode(this.getSchemeId());
            this.hashCode = this.hashCode * 89 + Integer.hashCode(this.getType());
            if (this.hashCode == -1) {
                ++this.hashCode;
            }
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.string == null) {
            StringWriter sw = new StringWriter();
            BufferedWriter stringBuffer = new BufferedWriter(sw);
            try {
                stringBuffer.write("Binding(");
                stringBuffer.write(this.getTriggerSequence().toString());
                stringBuffer.write(44);
                stringBuffer.newLine();
                stringBuffer.write(9);
                stringBuffer.write(this.command == null ? "" : this.command.toString());
                stringBuffer.write(44);
                stringBuffer.newLine();
                stringBuffer.write(9);
                stringBuffer.write(this.schemeId);
                stringBuffer.write(44);
                stringBuffer.newLine();
                stringBuffer.write(9);
                stringBuffer.write(this.contextId);
                stringBuffer.write(44);
                stringBuffer.write(this.locale == null ? "" : this.locale);
                stringBuffer.write(44);
                stringBuffer.write(this.platform == null ? "" : this.platform);
                stringBuffer.write(44);
                stringBuffer.write(this.type == 0 ? "system" : "user");
                stringBuffer.write(41);
                stringBuffer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.string = sw.toString();
        }
        return this.string;
    }
}

