/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGObject;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.StreamUtil;
import org.bouncycastle.util.BigIntegers;

public class MPInteger
extends BCPGObject {
    private final BigInteger value;

    public MPInteger(BCPGInputStream bCPGInputStream) throws IOException {
        boolean bl = false;
        this.value = MPInteger.readMPI(bCPGInputStream, bl);
    }

    public MPInteger(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.signum() < 0) {
            throw new IllegalArgumentException("value must not be null, or negative");
        }
        this.value = bigInteger;
    }

    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        StreamUtil.write2OctetLength(bCPGOutputStream, this.value.bitLength());
        BigIntegers.writeUnsignedByteArray((OutputStream)bCPGOutputStream, (BigInteger)this.value);
    }

    private static BigInteger readMPI(BCPGInputStream bCPGInputStream, boolean bl) throws IOException {
        int n = StreamUtil.read2OctetLength(bCPGInputStream);
        int n2 = (n + 7) / 8;
        byte[] byArray = new byte[n2];
        bCPGInputStream.readFully(byArray);
        BigInteger bigInteger = new BigInteger(1, byArray);
        if (bl && bigInteger.bitLength() != n) {
            throw new IOException("malformed MPI");
        }
        return bigInteger;
    }
}

