/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Win32DPIUtils;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.PointF;
import org.eclipse.swt.internal.win32.OS;

public class Pattern
extends Resource {
    private final Image image;
    private float baseX1;
    private float baseY1;
    private float baseX2;
    private float baseY2;
    private Color color1;
    private Color color2;
    private int alpha1;
    private int alpha2;
    private final Map<Integer, PatternHandle> zoomToHandle = new HashMap<Integer, PatternHandle>();
    private boolean isDestroyed;

    public Pattern(Device device, Image image) {
        super(device);
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.device.checkGDIP();
        this.image = image;
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public Pattern(Device device, float x1, float y1, float x2, float y2, Color color1, Color color2) {
        this(device, x1, y1, x2, y2, color1, 255, color2, 255);
    }

    public Pattern(Device device, float x1, float y1, float x2, float y2, Color color1, int alpha1, Color color2, int alpha2) {
        super(device);
        this.baseX1 = x1;
        this.baseX2 = x2;
        this.baseY1 = y1;
        this.baseY2 = y2;
        this.color1 = color1;
        this.color2 = color2;
        this.alpha1 = alpha1;
        this.alpha2 = alpha2;
        this.image = null;
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    private PatternHandle newPatternHandle(int zoom) {
        if (this.image != null) {
            return new ImagePatternHandle(zoom);
        }
        return new BasePatternHandle(zoom);
    }

    private PatternHandle getPatternHandle(int zoom) {
        if (!this.zoomToHandle.containsKey(zoom)) {
            this.zoomToHandle.put(zoom, this.newPatternHandle(zoom));
        }
        return this.zoomToHandle.get(zoom);
    }

    long getHandle(int zoom) {
        return this.getPatternHandle((int)zoom).handle;
    }

    @Override
    void destroy() {
        this.device.deregisterResourceWithZoomSupport(this);
        this.zoomToHandle.values().forEach(PatternHandle::destroy);
        this.zoomToHandle.clear();
        this.isDestroyed = true;
    }

    @Override
    void destroyHandlesExcept(Set<Integer> zoomLevels) {
        this.zoomToHandle.entrySet().removeIf(entry -> {
            Integer zoom = (Integer)entry.getKey();
            if (!zoomLevels.contains(zoom)) {
                ((PatternHandle)entry.getValue()).destroy();
                return true;
            }
            return false;
        });
    }

    Pattern copy() {
        if (this.image != null) {
            return new Pattern(this.device, this.image);
        }
        return new Pattern(this.device, this.baseX1, this.baseY1, this.baseX2, this.baseY2, this.color1, this.alpha1, this.color2, this.alpha2);
    }

    @Override
    public boolean isDisposed() {
        return this.isDestroyed;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Pattern {*DISPOSED*}";
        }
        return "Pattern {" + String.valueOf(this.zoomToHandle) + "}";
    }

    private class BasePatternHandle
    extends PatternHandle {
        public BasePatternHandle(int zoom) {
            super(zoom);
        }

        @Override
        long createHandle(int zoom) {
            long handle;
            float x1 = Win32DPIUtils.pointToPixel(Pattern.this.baseX1, zoom);
            float y1 = Win32DPIUtils.pointToPixel(Pattern.this.baseY1, zoom);
            float x2 = Win32DPIUtils.pointToPixel(Pattern.this.baseX2, zoom);
            float y2 = Win32DPIUtils.pointToPixel(Pattern.this.baseY2, zoom);
            if (Pattern.this.color1 == null) {
                SWT.error(4);
            }
            if (Pattern.this.color1.isDisposed()) {
                SWT.error(5);
            }
            if (Pattern.this.color2 == null) {
                SWT.error(4);
            }
            if (Pattern.this.color2.isDisposed()) {
                SWT.error(5);
            }
            Pattern.this.device.checkGDIP();
            int colorRef1 = Pattern.this.color1.handle;
            int foreColor = (Pattern.this.alpha1 & 0xFF) << 24 | colorRef1 >> 16 & 0xFF | colorRef1 & 0xFF00 | (colorRef1 & 0xFF) << 16;
            if (x1 == x2 && y1 == y2) {
                handle = Gdip.SolidBrush_new(foreColor);
                if (handle == 0L) {
                    SWT.error(2);
                }
            } else {
                int colorRef2 = Pattern.this.color2.handle;
                int backColor = (Pattern.this.alpha2 & 0xFF) << 24 | colorRef2 >> 16 & 0xFF | colorRef2 & 0xFF00 | (colorRef2 & 0xFF) << 16;
                PointF p1 = new PointF();
                p1.X = x1;
                p1.Y = y1;
                PointF p2 = new PointF();
                p2.X = x2;
                p2.Y = y2;
                handle = Gdip.LinearGradientBrush_new(p1, p2, foreColor, backColor);
                if (handle == 0L) {
                    SWT.error(2);
                }
                if (Pattern.this.alpha1 != 255 || Pattern.this.alpha2 != 255) {
                    int a = (int)((float)(Pattern.this.alpha1 & 0xFF) * 0.5f + (float)(Pattern.this.alpha2 & 0xFF) * 0.5f);
                    int r = (int)((float)((colorRef1 & 0xFF) >> 0) * 0.5f + (float)((colorRef2 & 0xFF) >> 0) * 0.5f);
                    int g = (int)((float)((colorRef1 & 0xFF00) >> 8) * 0.5f + (float)((colorRef2 & 0xFF00) >> 8) * 0.5f);
                    int b = (int)((float)((colorRef1 & 0xFF0000) >> 16) * 0.5f + (float)((colorRef2 & 0xFF0000) >> 16) * 0.5f);
                    int midColor = a << 24 | r << 16 | g << 8 | b;
                    Gdip.LinearGradientBrush_SetInterpolationColors(handle, new int[]{foreColor, midColor, backColor}, new float[]{0.0f, 0.5f, 1.0f}, 3);
                }
            }
            return handle;
        }
    }

    private class ImagePatternHandle
    extends PatternHandle {
        private long[] gdipImage;

        public ImagePatternHandle(int zoom) {
            super(zoom);
        }

        @Override
        long createHandle(int zoom) {
            int height;
            this.gdipImage = Pattern.this.image.createGdipImage(zoom);
            long img = this.gdipImage[0];
            int width = Gdip.Image_GetWidth(img);
            long handle = Gdip.TextureBrush_new(img, 0, 0.0f, 0.0f, width, height = Gdip.Image_GetHeight(img));
            if (handle == 0L) {
                this.cleanupBitmap();
                SWT.error(2);
            }
            return handle;
        }

        @Override
        protected void destroy() {
            super.destroy();
            this.cleanupBitmap();
        }

        private void cleanupBitmap() {
            if (this.gdipImage.length < 2) {
                return;
            }
            long img = this.gdipImage[0];
            Gdip.Bitmap_delete(img);
            if (this.gdipImage[1] != 0L) {
                long hHeap = OS.GetProcessHeap();
                OS.HeapFree(hHeap, 0, this.gdipImage[1]);
            }
        }
    }

    private abstract class PatternHandle {
        private final long handle;

        public PatternHandle(int zoom) {
            this.handle = this.createHandle(zoom);
        }

        abstract long createHandle(int var1);

        protected void destroy() {
            int type = Gdip.Brush_GetType(this.handle);
            switch (type) {
                case 0: {
                    Gdip.SolidBrush_delete(this.handle);
                    break;
                }
                case 1: {
                    Gdip.HatchBrush_delete(this.handle);
                    break;
                }
                case 4: {
                    Gdip.LinearGradientBrush_delete(this.handle);
                    break;
                }
                case 2: {
                    Gdip.TextureBrush_delete(this.handle);
                }
            }
        }
    }
}

