/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.IObjectActionContributor;
import org.eclipse.ui.internal.IObjectContributor;
import org.eclipse.ui.internal.ObjectActionContributorReader;
import org.eclipse.ui.internal.ObjectContributorManager;

public class ObjectActionContributorManager
extends ObjectContributorManager {
    private static ObjectActionContributorManager sharedInstance;

    public ObjectActionContributorManager() {
        this.loadContributors();
    }

    public boolean contributeObjectActions(IWorkbenchPart part, IMenuManager popupMenu, ISelectionProvider selProv, Set<IObjectActionContributor> alreadyContributed) {
        ISelection selection = selProv.getSelection();
        if (selection == null) {
            return false;
        }
        ArrayList<ISelection> elements = null;
        if (selection instanceof IStructuredSelection) {
            elements = ((IStructuredSelection)selection).toList();
        } else {
            elements = new ArrayList<ISelection>(1);
            elements.add(selection);
        }
        List contributors = this.getContributors(elements);
        contributors.removeAll(alreadyContributed);
        if (contributors.isEmpty()) {
            return false;
        }
        boolean actualContributions = false;
        ArrayList overrides = new ArrayList(4);
        Iterator it = contributors.iterator();
        while (it.hasNext()) {
            IObjectActionContributor contributor = (IObjectActionContributor)it.next();
            if (!this.isApplicableTo(elements, (IObjectContributor)contributor)) {
                it.remove();
                continue;
            }
            if (contributor.contributeObjectMenus(popupMenu, selProv)) {
                actualContributions = true;
                alreadyContributed.add(contributor);
            }
            contributor.contributeObjectActionIdOverrides(overrides);
        }
        for (IObjectActionContributor contributor : contributors) {
            if (!contributor.contributeObjectActions(part, popupMenu, selProv, overrides)) continue;
            actualContributions = true;
            alreadyContributed.add(contributor);
        }
        return actualContributions;
    }

    public static synchronized ObjectActionContributorManager getManager() {
        if (sharedInstance == null) {
            sharedInstance = new ObjectActionContributorManager();
        }
        return sharedInstance;
    }

    public static synchronized void disposeManager() {
        if (sharedInstance != null) {
            sharedInstance.dispose();
        }
    }

    private void loadContributors() {
        ObjectActionContributorReader reader = new ObjectActionContributorReader();
        reader.readPopupContributors(this);
    }

    public void addExtension(IExtensionTracker tracker, IExtension addedExtension) {
        IConfigurationElement[] addedElements;
        IConfigurationElement[] iConfigurationElementArray = addedElements = addedExtension.getConfigurationElements();
        int n = addedElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement addedElement = iConfigurationElementArray[n2];
            ObjectActionContributorReader reader = new ObjectActionContributorReader();
            reader.setManager(this);
            reader.readElement(addedElement);
            ++n2;
        }
    }

    @Override
    protected String getExtensionPointFilter() {
        return "popupMenus";
    }
}

