/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.extractor.lib;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.oomph.extractor.lib.IO;
import org.eclipse.oomph.extractor.lib.JREData;

public final class BINDescriptor {
    private static final String CHARSET = "UTF-8";
    private static final String NL = "\n";
    private final int format;
    private final JREData jre;
    private final int jdk;
    private final String launcherPath;
    private final String iniPath;
    private final String productName;
    private final String productURI;
    private final String imageURI;

    public BINDescriptor(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, CHARSET));
        this.format = BINDescriptor.readInt(reader);
        int major = BINDescriptor.readInt(reader);
        int minor = BINDescriptor.readInt(reader);
        int micro = BINDescriptor.readInt(reader);
        int bitness = BINDescriptor.readInt(reader);
        this.jre = new JREData(major, minor, micro, bitness);
        this.jdk = BINDescriptor.readInt(reader);
        this.launcherPath = reader.readLine();
        this.iniPath = reader.readLine();
        this.productName = reader.readLine();
        this.productURI = reader.readLine();
        this.imageURI = reader.readLine();
    }

    public int getFormat() {
        return this.format;
    }

    public JREData getJRE() {
        return this.jre;
    }

    public int getJDK() {
        return this.jdk;
    }

    public String getLauncherPath() {
        return this.launcherPath;
    }

    public String getIniPath() {
        return this.iniPath;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductURI() {
        return this.productURI;
    }

    public String getImageURI() {
        return this.imageURI;
    }

    public void write(File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, CHARSET));
            BINDescriptor.writeInt(writer, this.format);
            BINDescriptor.writeInt(writer, this.jre.getMajor());
            BINDescriptor.writeInt(writer, this.jre.getMinor());
            BINDescriptor.writeInt(writer, this.jre.getMicro());
            BINDescriptor.writeInt(writer, this.jre.getBitness());
            BINDescriptor.writeInt(writer, this.jdk);
            this.writeString(writer, this.launcherPath);
            this.writeString(writer, this.iniPath);
            this.writeString(writer, this.productName);
            this.writeString(writer, this.productURI);
            this.writeString(writer, this.imageURI);
            writer.flush();
        }
        finally {
            IO.close(out);
        }
    }

    private static int readInt(BufferedReader reader) throws IOException {
        return Integer.parseInt(reader.readLine());
    }

    private static void writeInt(BufferedWriter writer, int value) throws IOException {
        writer.write(Integer.toString(value));
        writer.write(NL);
    }

    private void writeString(BufferedWriter writer, String value) throws IOException {
        writer.write(value);
        writer.write(NL);
    }
}

