/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.projectconfig.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.oomph.base.impl.ModelElementImpl;
import org.eclipse.oomph.predicates.Predicate;
import org.eclipse.oomph.preferences.PreferenceNode;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.eclipse.oomph.projectconfig.PreferenceFilter;
import org.eclipse.oomph.projectconfig.PreferenceProfile;
import org.eclipse.oomph.projectconfig.Project;
import org.eclipse.oomph.projectconfig.ProjectConfigPackage;
import org.eclipse.oomph.projectconfig.WorkspaceConfiguration;
import org.eclipse.oomph.projectconfig.impl.ProjectConfigPlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class WorkspaceConfigurationImpl
extends ModelElementImpl
implements WorkspaceConfiguration {
    private static final IWorkspaceRoot WORKSPACE_ROOT = ResourcesPlugin.getWorkspace().getRoot();
    protected EList<Project> projects;
    protected PreferenceNode defaultPreferenceNode;
    protected PreferenceNode instancePreferenceNode;

    protected WorkspaceConfigurationImpl() {
    }

    protected EClass eStaticClass() {
        return ProjectConfigPackage.Literals.WORKSPACE_CONFIGURATION;
    }

    @Override
    public EList<Project> getProjects() {
        if (this.projects == null) {
            this.projects = new EObjectContainmentWithInverseEList(Project.class, (InternalEObject)this, 1, 1);
        }
        return this.projects;
    }

    @Override
    public PreferenceNode getDefaultPreferenceNode() {
        if (this.defaultPreferenceNode != null && this.defaultPreferenceNode.eIsProxy()) {
            InternalEObject oldDefaultPreferenceNode = (InternalEObject)this.defaultPreferenceNode;
            this.defaultPreferenceNode = (PreferenceNode)this.eResolveProxy(oldDefaultPreferenceNode);
            if (this.defaultPreferenceNode != oldDefaultPreferenceNode && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 2, (Object)oldDefaultPreferenceNode, (Object)this.defaultPreferenceNode));
            }
        }
        return this.defaultPreferenceNode;
    }

    public PreferenceNode basicGetDefaultPreferenceNode() {
        return this.defaultPreferenceNode;
    }

    @Override
    public void setDefaultPreferenceNode(PreferenceNode newDefaultPreferenceNode) {
        PreferenceNode oldDefaultPreferenceNode = this.defaultPreferenceNode;
        this.defaultPreferenceNode = newDefaultPreferenceNode;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldDefaultPreferenceNode, (Object)this.defaultPreferenceNode));
        }
    }

    @Override
    public PreferenceNode getInstancePreferenceNode() {
        if (this.instancePreferenceNode != null && this.instancePreferenceNode.eIsProxy()) {
            InternalEObject oldInstancePreferenceNode = (InternalEObject)this.instancePreferenceNode;
            this.instancePreferenceNode = (PreferenceNode)this.eResolveProxy(oldInstancePreferenceNode);
            if (this.instancePreferenceNode != oldInstancePreferenceNode && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)oldInstancePreferenceNode, (Object)this.instancePreferenceNode));
            }
        }
        return this.instancePreferenceNode;
    }

    public PreferenceNode basicGetInstancePreferenceNode() {
        return this.instancePreferenceNode;
    }

    @Override
    public void setInstancePreferenceNode(PreferenceNode newInstancePreferenceNode) {
        PreferenceNode oldInstancePreferenceNode = this.instancePreferenceNode;
        this.instancePreferenceNode = newInstancePreferenceNode;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldInstancePreferenceNode, (Object)this.instancePreferenceNode));
        }
    }

    @Override
    public void applyPreferenceProfiles() {
        try {
            WORKSPACE_ROOT.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    Preferences projectsPreferences = null;
                    for (Project project : WorkspaceConfigurationImpl.this.getProjects()) {
                        try {
                            Preferences projectPreferences = PreferencesUtil.getPreferences((PreferenceNode)project.getPreferenceNode(), (boolean)true);
                            projectsPreferences = projectPreferences.parent();
                            for (PreferenceProfile preferenceProfile : project.getPreferenceProfileReferences()) {
                                if (preferenceProfile.getProject() == project) continue;
                                for (PreferenceFilter preferenceFilter : preferenceProfile.getPreferenceFilters()) {
                                    PreferenceNode preferenceNode = preferenceFilter.getPreferenceNode();
                                    Preferences sourcePreferences = PreferencesUtil.getPreferences((PreferenceNode)preferenceNode, (boolean)true);
                                    if (projectPreferences == null) {
                                        projectPreferences = PreferencesUtil.getPreferences((PreferenceNode)project.getPreferenceNode(), (boolean)true);
                                    }
                                    Preferences targetPreferences = projectPreferences;
                                    String[] stringArray = preferenceNode.getRelativePath().segments();
                                    int n = stringArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String segment = stringArray[n2];
                                        targetPreferences = targetPreferences.node(URI.decode((String)segment));
                                        ++n2;
                                    }
                                    stringArray = sourcePreferences.keys();
                                    n = stringArray.length;
                                    n2 = 0;
                                    while (n2 < n) {
                                        String key = stringArray[n2];
                                        if (preferenceFilter.matches(key)) {
                                            targetPreferences.put(key, sourcePreferences.get(key, null));
                                        }
                                        ++n2;
                                    }
                                }
                            }
                        }
                        catch (BackingStoreException ex) {
                            ProjectConfigPlugin.INSTANCE.log((Object)ex);
                        }
                    }
                    if (projectsPreferences != null) {
                        try {
                            projectsPreferences.flush();
                        }
                        catch (BackingStoreException ex) {
                            ProjectConfigPlugin.INSTANCE.log((Object)ex);
                        }
                    }
                }
            }, null);
        }
        catch (CoreException ex) {
            ProjectConfigPlugin.INSTANCE.log((Object)ex);
        }
    }

    @Override
    public void updatePreferenceProfileReferences() {
        for (Project project : this.getProjects()) {
            for (PreferenceProfile preferenceProfile : project.getPreferenceProfiles()) {
                EList<Predicate> predicates = preferenceProfile.getPredicates();
                if (predicates.isEmpty()) continue;
                ArrayList<Project> referents = new ArrayList<Project>();
                for (Project referencedProject : this.getProjects()) {
                    IProject iProject;
                    if (referencedProject == project || !(iProject = WORKSPACE_ROOT.getProject(referencedProject.getPreferenceNode().getName())).isAccessible() || !preferenceProfile.matches(iProject)) continue;
                    referents.add(referencedProject);
                }
                ECollections.setEList(preferenceProfile.getReferentProjects(), referents);
            }
        }
    }

    @Override
    public Project getProject(String name) {
        for (Project project : this.getProjects()) {
            if (!name.equals(project.getPreferenceNode().getName())) continue;
            return project;
        }
        return null;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getProjects()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getProjects()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getProjects();
            }
            case 2: {
                if (resolve) {
                    return this.getDefaultPreferenceNode();
                }
                return this.basicGetDefaultPreferenceNode();
            }
            case 3: {
                if (resolve) {
                    return this.getInstancePreferenceNode();
                }
                return this.basicGetInstancePreferenceNode();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getProjects().clear();
                this.getProjects().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.setDefaultPreferenceNode((PreferenceNode)newValue);
                return;
            }
            case 3: {
                this.setInstancePreferenceNode((PreferenceNode)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getProjects().clear();
                return;
            }
            case 2: {
                this.setDefaultPreferenceNode(null);
                return;
            }
            case 3: {
                this.setInstancePreferenceNode(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.projects != null && !this.projects.isEmpty();
            }
            case 2: {
                return this.defaultPreferenceNode != null;
            }
            case 3: {
                return this.instancePreferenceNode != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 1: {
                this.applyPreferenceProfiles();
                return null;
            }
            case 2: {
                this.updatePreferenceProfileReferences();
                return null;
            }
            case 3: {
                return this.getProject((String)arguments.get(0));
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String eURIFragmentSegment(EStructuralFeature eStructuralFeature, EObject eObject) {
        String name;
        Project child;
        PreferenceNode preferenceNode;
        if (eStructuralFeature == ProjectConfigPackage.Literals.WORKSPACE_CONFIGURATION__PROJECTS && (preferenceNode = (child = (Project)eObject).getPreferenceNode()) != null && (name = preferenceNode.getName()) != null) {
            Object encodedName = URI.encodeSegment((String)name, (boolean)false);
            if (((String)encodedName).startsWith("@")) {
                encodedName = "%40" + ((String)encodedName).substring(1);
            }
            return name;
        }
        return super.eURIFragmentSegment(eStructuralFeature, eObject);
    }

    public EObject eObjectForURIFragmentSegment(String uriFragmentSegment) {
        if (!uriFragmentSegment.startsWith("@")) {
            String preferenceNodeName = URI.decode((String)uriFragmentSegment);
            for (Project project : this.getProjects()) {
                PreferenceNode preferenceNode = project.getPreferenceNode();
                if (preferenceNode == null || !preferenceNodeName.equals(preferenceNode.getName())) continue;
                return project;
            }
            return null;
        }
        return super.eObjectForURIFragmentSegment(uriFragmentSegment);
    }
}

