/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.container;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public final class KeyBasedLockStore<Key, Lock> {
    final ReferenceQueue<Lock> refQueue = new ReferenceQueue();
    private final ConcurrentHashMap<Key, LockWeakRef> lockMap = new ConcurrentHashMap();
    private final Function<Key, Lock> lockCreator;

    public KeyBasedLockStore(Function<Key, Lock> lockCreator) {
        this.lockCreator = lockCreator;
    }

    public final Lock getLock(Key key) {
        Lock lock;
        this.poll();
        LockWeakRef lockRef = this.lockMap.get(key);
        Lock Lock2 = lock = lockRef != null ? (Lock)lockRef.get() : null;
        if (lock != null) {
            return lock;
        }
        lock = this.lockCreator.apply(key);
        LockWeakRef retVal;
        while ((retVal = this.lockMap.putIfAbsent(key, new LockWeakRef(lock, key))) != null) {
            Object retLock = retVal.get();
            if (retLock != null) {
                return (Lock)retLock;
            }
            this.lockMap.remove(key, retVal);
        }
        return lock;
    }

    private final void poll() {
        LockWeakRef lockRef;
        while ((lockRef = (LockWeakRef)this.refQueue.poll()) != null) {
            this.lockMap.remove(lockRef.key, lockRef);
        }
    }

    private final class LockWeakRef
    extends WeakReference<Lock> {
        final Key key;

        public LockWeakRef(Lock referent, Key keyValue) {
            super(referent, KeyBasedLockStore.this.refQueue);
            this.key = keyValue;
        }
    }
}

