/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPageService;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.services.IDisposable;

public class SlavePageService
implements IPageService,
IDisposable {
    private IPageService parent;
    private ListenerList<IPageListener> pageListeners = new ListenerList(1);
    private ListenerList<IPerspectiveListener> perspectiveListeners = new ListenerList(1);

    public SlavePageService(IPageService parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent IPageService cannot be null");
        }
        this.parent = parent;
    }

    @Override
    public void addPageListener(IPageListener listener) {
        this.pageListeners.add((Object)listener);
        this.parent.addPageListener(listener);
    }

    @Override
    public void addPerspectiveListener(IPerspectiveListener listener) {
        this.perspectiveListeners.add((Object)listener);
        this.parent.addPerspectiveListener(listener);
    }

    @Override
    public IWorkbenchPage getActivePage() {
        return this.parent.getActivePage();
    }

    @Override
    public void removePageListener(IPageListener listener) {
        this.pageListeners.remove((Object)listener);
        this.parent.removePageListener(listener);
    }

    @Override
    public void removePerspectiveListener(IPerspectiveListener listener) {
        this.perspectiveListeners.remove((Object)listener);
        this.parent.removePerspectiveListener(listener);
    }

    @Override
    public void dispose() {
        for (Object listener : this.pageListeners) {
            this.parent.removePageListener((IPageListener)listener);
        }
        this.pageListeners.clear();
        for (Object listener : this.perspectiveListeners) {
            this.parent.removePerspectiveListener((IPerspectiveListener)listener);
        }
        this.perspectiveListeners.clear();
    }
}

