/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Tree;

public class TreeDropTargetEffect
extends DropTargetEffect {
    boolean shouldEnableScrolling;

    public TreeDropTargetEffect(Tree tree) {
        super(tree);
    }

    int checkEffect(int effect) {
        if ((effect & 1) != 0) {
            effect = effect & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((effect & 2) != 0) {
            effect &= 0xFFFFFFFB;
        }
        return effect;
    }

    @Override
    public void dragEnter(DropTargetEvent event) {
    }

    @Override
    public void dragLeave(DropTargetEvent event) {
        OS.objc_msgSend(this.control.view.id, OS.sel_setShouldExpandItem_, 1);
        if (this.shouldEnableScrolling) {
            this.shouldEnableScrolling = false;
            OS.objc_msgSend(this.control.view.id, OS.sel_setShouldScrollClipView_, 1);
            this.control.redraw();
        }
    }

    @Override
    public void dragOver(DropTargetEvent event) {
        int effect;
        ((DropTarget)event.widget).feedback = effect = this.checkEffect(event.feedback);
        OS.objc_msgSend(this.control.view.id, OS.sel_setShouldExpandItem_, (effect & 0x10) == 0 ? 0 : 1);
        if ((effect & 8) == 0) {
            this.shouldEnableScrolling = true;
            OS.objc_msgSend(this.control.view.id, OS.sel_setShouldScrollClipView_, 0);
        } else {
            OS.objc_msgSend(this.control.view.id, OS.sel_setShouldScrollClipView_, 1);
        }
    }
}

