/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.handlers.CollapseAllHandler;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.navigator.actions.CollapseAllAction;
import org.eclipse.ui.internal.navigator.actions.LinkEditorAction;
import org.eclipse.ui.internal.navigator.filters.FilterActionGroup;
import org.eclipse.ui.internal.navigator.framelist.BackAction;
import org.eclipse.ui.internal.navigator.framelist.ForwardAction;
import org.eclipse.ui.internal.navigator.framelist.FrameList;
import org.eclipse.ui.internal.navigator.framelist.UpAction;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.IMementoAware;
import org.eclipse.ui.navigator.INavigatorViewerDescriptor;
import org.eclipse.ui.navigator.LinkHelperService;

public class CommonNavigatorActionGroup
extends ActionGroup
implements IMementoAware {
    private static final String FRAME_ACTION_SEPARATOR_ID = "FRAME_ACTION_SEPARATOR_ID";
    private static final String FRAME_ACTION_GROUP_ID = "FRAME_ACTION_GROUP_ID";
    private BackAction backAction;
    private ForwardAction forwardAction;
    private UpAction upAction;
    private LinkEditorAction toggleLinkingAction;
    private CollapseAllAction collapseAllAction;
    private FilterActionGroup filterGroup;
    private final CommonViewer commonViewer;
    private CommonNavigator commonNavigator;
    private final LinkHelperService linkHelperService;
    private CollapseAllHandler collapseAllHandler;
    private boolean frameActionsShown;

    public CommonNavigatorActionGroup(CommonNavigator aNavigator, CommonViewer aViewer, LinkHelperService linkHelperService) {
        this.commonNavigator = aNavigator;
        this.commonViewer = aViewer;
        this.linkHelperService = linkHelperService;
        this.makeActions();
    }

    private void makeActions() {
        boolean hideCollapseAllAction;
        FrameList frameList = this.commonViewer.getFrameList();
        this.backAction = new BackAction(frameList);
        this.forwardAction = new ForwardAction(frameList);
        this.upAction = new UpAction(frameList);
        frameList.addPropertyChangeListener(event -> {
            if (event.getProperty().equals("reset")) {
                this.upAction.setEnabled(false);
                this.backAction.setEnabled(false);
                this.forwardAction.setEnabled(false);
                this.upAction.update();
            }
            this.commonNavigator.updateTitle();
            IActionBars actionBars = this.commonNavigator.getViewSite().getActionBars();
            this.updateToolBar(actionBars.getToolBarManager());
            actionBars.updateActionBars();
        });
        IHandlerService service = (IHandlerService)this.commonNavigator.getSite().getService(IHandlerService.class);
        INavigatorViewerDescriptor viewerDescriptor = this.commonViewer.getNavigatorContentService().getViewerDescriptor();
        boolean hideLinkWithEditorAction = viewerDescriptor.getBooleanConfigProperty("org.eclipse.ui.navigator.hideLinkWithEditorAction");
        if (!hideLinkWithEditorAction) {
            this.toggleLinkingAction = new LinkEditorAction(this.commonNavigator, this.commonViewer, this.linkHelperService);
            String imageFilePath = "icons/full/elcl16/synced.svg";
            ResourceLocator.imageDescriptorFromBundle(this.getClass(), (String)imageFilePath).ifPresent(d -> this.toggleLinkingAction.setImageDescriptor((ImageDescriptor)d));
            service.activateHandler(this.toggleLinkingAction.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.toggleLinkingAction));
        }
        if (!(hideCollapseAllAction = viewerDescriptor.getBooleanConfigProperty("org.eclipse.ui.navigator.hideCollapseAllAction"))) {
            this.collapseAllAction = new CollapseAllAction(this.commonViewer);
            String imageFilePath = "icons/full/elcl16/collapseall.svg";
            ResourceLocator.imageDescriptorFromBundle(this.getClass(), (String)imageFilePath).ifPresent(d -> this.collapseAllAction.setImageDescriptor((ImageDescriptor)d));
            this.collapseAllHandler = new CollapseAllHandler((AbstractTreeViewer)this.commonViewer);
            service.activateHandler("org.eclipse.ui.navigate.collapseAll", (IHandler)this.collapseAllHandler);
        }
        this.filterGroup = this.createFilterActionGroup(this.commonViewer);
    }

    protected FilterActionGroup createFilterActionGroup(CommonViewer pCommonViewer) {
        return new FilterActionGroup(pCommonViewer);
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.BACK.getId(), (IAction)this.backAction);
        actionBars.setGlobalActionHandler(ActionFactory.FORWARD.getId(), (IAction)this.forwardAction);
        actionBars.setGlobalActionHandler("up", (IAction)this.upAction);
        this.filterGroup.fillActionBars(actionBars);
        this.fillToolBar(actionBars.getToolBarManager());
        this.fillViewMenu(actionBars.getMenuManager());
        actionBars.updateActionBars();
    }

    protected void fillToolBar(IToolBarManager toolBar) {
        if (this.backAction.isEnabled() || this.upAction.isEnabled() || this.forwardAction.isEnabled()) {
            toolBar.add((IAction)this.backAction);
            toolBar.add((IAction)this.forwardAction);
            toolBar.add((IAction)this.upAction);
            toolBar.add((IContributionItem)new Separator(FRAME_ACTION_SEPARATOR_ID));
            this.frameActionsShown = true;
        }
        toolBar.add((IContributionItem)new GroupMarker(FRAME_ACTION_GROUP_ID));
        if (this.collapseAllAction != null) {
            toolBar.add((IAction)this.collapseAllAction);
        }
        if (this.toggleLinkingAction != null) {
            toolBar.add((IAction)this.toggleLinkingAction);
        }
    }

    protected void fillViewMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("additions-end"));
        if (this.toggleLinkingAction != null) {
            menu.insertAfter("additions-end", (IAction)this.toggleLinkingAction);
        }
    }

    private void updateToolBar(IToolBarManager toolBar) {
        boolean hasBeenFrameActionsShown = this.frameActionsShown;
        boolean bl = this.frameActionsShown = this.backAction.isEnabled() || this.upAction.isEnabled() || this.forwardAction.isEnabled();
        if (this.frameActionsShown != hasBeenFrameActionsShown) {
            if (hasBeenFrameActionsShown) {
                toolBar.remove(this.backAction.getId());
                toolBar.remove(this.forwardAction.getId());
                toolBar.remove(this.upAction.getId());
                toolBar.remove(FRAME_ACTION_SEPARATOR_ID);
            } else {
                toolBar.prependToGroup(FRAME_ACTION_GROUP_ID, (IContributionItem)new Separator(FRAME_ACTION_SEPARATOR_ID));
                toolBar.prependToGroup(FRAME_ACTION_GROUP_ID, (IAction)this.upAction);
                toolBar.prependToGroup(FRAME_ACTION_GROUP_ID, (IAction)this.forwardAction);
                toolBar.prependToGroup(FRAME_ACTION_GROUP_ID, (IAction)this.backAction);
            }
            toolBar.update(true);
        }
    }

    public void dispose() {
        super.dispose();
        this.backAction.dispose();
        this.forwardAction.dispose();
        this.upAction.dispose();
        if (this.toggleLinkingAction != null) {
            this.toggleLinkingAction.dispose();
        }
        if (this.collapseAllHandler != null) {
            this.collapseAllHandler.dispose();
        }
    }

    @Override
    public void restoreState(IMemento aMemento) {
        this.filterGroup.restoreState(aMemento);
    }

    @Override
    public void saveState(IMemento aMemento) {
        this.filterGroup.saveState(aMemento);
    }
}

