/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.examples;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.nebula.visualization.widgets.figures.ThermometerFigure;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ThermometerExample {
    private static int counter = 0;

    public static void main(String[] args) {
        Shell shell = new Shell();
        shell.setSize(300, 250);
        shell.open();
        LightweightSystem lws = new LightweightSystem((Canvas)shell);
        final ThermometerFigure thermo = new ThermometerFigure();
        thermo.setBackgroundColor(XYGraphMediaFactory.getInstance().getColor(255, 255, 255));
        thermo.setBorder((Border)new SchemeBorder(SchemeBorder.SCHEMES.ETCHED));
        thermo.setRange(-100.0, 100.0);
        thermo.setLoLevel(-50.0);
        thermo.setLoloLevel(-80.0);
        thermo.setHiLevel(60.0);
        thermo.setHihiLevel(80.0);
        thermo.setShowHi(false);
        thermo.setMajorTickMarkStepHint(50);
        lws.setContents((IFigure)thermo);
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        ScheduledFuture<?> future = scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        thermo.setValue(Math.sin((double)counter++ / 10.0) * 100.0);
                    }
                });
            }
        }, 100L, 100L, TimeUnit.MILLISECONDS);
        Display display = Display.getDefault();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        future.cancel(true);
        scheduler.shutdown();
    }
}

