/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.example;

import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.nebula.examples.AbstractExampleTab;
import org.eclipse.nebula.examples.ButtonFactory;
import org.eclipse.nebula.examples.ExamplesView;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridColumnGroup;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public class GridExampleTab
extends AbstractExampleTab {
    private Button vScroll;
    private Button hScroll;
    private Button border;
    private Button single;
    private Button multi;
    private Grid grid;
    private Button showLines;
    private Button showHeader;
    private Button showRowHeader;
    private Button columnScrolling;
    private Button moveableColumns;
    private Button resizeableColumns;
    private Button left;
    private Button center;
    private Button right;
    private Button columnCheck;
    private Button check;
    private Button toggle;
    private Button cellSelection;
    private Button selectionEnabled;
    private Button columnCellSelection;
    private Button columnWordWrap;
    private Spinner rowHeight;
    private Button rowsResizable;

    public void createParameters(Composite parent) {
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(2).applyTo(parent);
        Group styles = new Group(parent, 16);
        styles.setText("Styles");
        styles.setLayout((Layout)new GridLayout());
        styles.setLayoutData((Object)new GridData(1040));
        Listener listenerRecreates = new Listener(){

            public void handleEvent(Event event) {
                Button b;
                if (event.widget instanceof Button && ((b = (Button)event.widget).getStyle() & 0x10) != 0 && !b.getSelection()) {
                    return;
                }
                GridExampleTab.this.recreateExample();
            }
        };
        this.vScroll = ButtonFactory.create((Composite)styles, (int)32, (String)"SWT.V_SCROLL", (Listener)listenerRecreates, (boolean)true);
        this.hScroll = ButtonFactory.create((Composite)styles, (int)32, (String)"SWT.H_SCROLL", (Listener)listenerRecreates, (boolean)true);
        this.border = ButtonFactory.create((Composite)styles, (int)32, (String)"SWT.BORDER", (Listener)listenerRecreates, (boolean)true);
        Composite selectionComp = new Composite((Composite)styles, 0);
        GridLayoutFactory.swtDefaults().margins(0, 0).applyTo(selectionComp);
        this.single = ButtonFactory.create((Composite)selectionComp, (int)16, (String)"SWT.SINGLE", (Listener)listenerRecreates, (boolean)true);
        this.multi = ButtonFactory.create((Composite)selectionComp, (int)16, (String)"SWT.MULTI", (Listener)listenerRecreates);
        this.check = ButtonFactory.create((Composite)styles, (int)32, (String)"SWT.CHECK", (Listener)listenerRecreates, (boolean)false);
        Label l = new Label((Composite)styles, 0);
        l.setText("Styles for Second Column:");
        Composite alignmentComp = new Composite((Composite)styles, 0);
        GridLayoutFactory.swtDefaults().margins(0, 0).applyTo(alignmentComp);
        this.left = ButtonFactory.create((Composite)alignmentComp, (int)16, (String)"SWT.LEFT", (Listener)listenerRecreates, (boolean)true);
        this.center = ButtonFactory.create((Composite)alignmentComp, (int)16, (String)"SWT.CENTER", (Listener)listenerRecreates, (boolean)false);
        this.right = ButtonFactory.create((Composite)alignmentComp, (int)16, (String)"SWT.RIGHT", (Listener)listenerRecreates, (boolean)false);
        this.columnCheck = ButtonFactory.create((Composite)styles, (int)32, (String)"SWT.CHECK", (Listener)listenerRecreates, (boolean)false);
        l = new Label((Composite)styles, 0);
        l.setText("Styles for Column Group:");
        this.toggle = ButtonFactory.create((Composite)styles, (int)32, (String)"SWT.TOGGLE", (Listener)listenerRecreates, (boolean)true);
        Group other = new Group(parent, 16);
        other.setText("Other");
        other.setLayout((Layout)new GridLayout());
        other.setLayoutData((Object)new GridData(1040));
        this.showLines = ButtonFactory.create((Composite)other, (int)32, (String)"Show Lines", (Listener)new Listener(){

            public void handleEvent(Event event) {
                GridExampleTab.this.grid.setLinesVisible(GridExampleTab.this.showLines.getSelection());
            }
        }, (boolean)true);
        this.showHeader = ButtonFactory.create((Composite)other, (int)32, (String)"Show Column Headers", (Listener)new Listener(){

            public void handleEvent(Event event) {
                GridExampleTab.this.grid.setHeaderVisible(GridExampleTab.this.showHeader.getSelection());
            }
        }, (boolean)true);
        this.showRowHeader = ButtonFactory.create((Composite)other, (int)32, (String)"Show Row Headers", (Listener)new Listener(){

            public void handleEvent(Event event) {
                GridExampleTab.this.grid.setRowHeaderVisible(GridExampleTab.this.showRowHeader.getSelection());
                GridExampleTab.this.columnScrolling.setEnabled(!GridExampleTab.this.showRowHeader.getSelection());
                if (GridExampleTab.this.showRowHeader.getSelection()) {
                    GridExampleTab.this.columnScrolling.setSelection(true);
                }
            }
        });
        this.columnScrolling = ButtonFactory.create((Composite)other, (int)32, (String)"Scroll by Column", (Listener)new Listener(){

            public void handleEvent(Event event) {
                GridExampleTab.this.grid.setColumnScrolling(GridExampleTab.this.columnScrolling.getSelection());
            }
        });
        this.moveableColumns = ButtonFactory.create((Composite)other, (int)32, (String)"Moveable Columns", (Listener)new Listener(){

            public void handleEvent(Event event) {
                int i = 0;
                while (i < GridExampleTab.this.grid.getColumns().length) {
                    GridExampleTab.this.grid.getColumn(i).setMoveable(GridExampleTab.this.moveableColumns.getSelection());
                    ++i;
                }
            }
        }, (boolean)true);
        this.resizeableColumns = ButtonFactory.create((Composite)other, (int)32, (String)"Resizeable Columns", (Listener)new Listener(){

            public void handleEvent(Event event) {
                int i = 0;
                while (i < GridExampleTab.this.grid.getColumns().length) {
                    GridExampleTab.this.grid.getColumn(i).setResizeable(GridExampleTab.this.resizeableColumns.getSelection());
                    ++i;
                }
            }
        }, (boolean)true);
        this.selectionEnabled = ButtonFactory.create((Composite)other, (int)32, (String)"Selection Enabled", (Listener)new Listener(){

            public void handleEvent(Event event) {
                int i = 0;
                while (i < GridExampleTab.this.grid.getColumns().length) {
                    GridExampleTab.this.grid.setSelectionEnabled(GridExampleTab.this.selectionEnabled.getSelection());
                    ++i;
                }
            }
        }, (boolean)true);
        this.cellSelection = ButtonFactory.create((Composite)other, (int)32, (String)"Cell Selection", (Listener)new Listener(){

            public void handleEvent(Event event) {
                int i = 0;
                while (i < GridExampleTab.this.grid.getColumns().length) {
                    GridExampleTab.this.grid.setCellSelectionEnabled(GridExampleTab.this.cellSelection.getSelection());
                    ++i;
                }
            }
        });
        Composite rowHeightComposite = new Composite((Composite)other, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(rowHeightComposite);
        l = new Label(rowHeightComposite, 0);
        l.setText("Item Height:");
        this.rowHeight = new Spinner(rowHeightComposite, 2048);
        this.rowHeight.setValues(0, 0, 1000, 0, 1, 1);
        this.rowHeight.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GridExampleTab.this.grid.setItemHeight(GridExampleTab.this.rowHeight.getSelection());
            }
        });
        this.rowsResizable = ButtonFactory.create((Composite)other, (int)32, (String)"Rows Resizable", (Listener)new Listener(){

            public void handleEvent(Event event) {
                GridExampleTab.this.grid.setRowsResizeable(GridExampleTab.this.rowsResizable.getSelection());
            }
        });
        l = new Label((Composite)other, 0);
        l.setText("Properties for Second Column:");
        this.columnCellSelection = ButtonFactory.create((Composite)other, (int)32, (String)"Cell Selection Enabled", (Listener)new Listener(){

            public void handleEvent(Event event) {
                int i = 0;
                while (i < GridExampleTab.this.grid.getColumns().length) {
                    GridExampleTab.this.grid.getColumn(1).setCellSelectionEnabled(GridExampleTab.this.columnCellSelection.getSelection());
                    ++i;
                }
            }
        }, (boolean)true);
        this.columnWordWrap = ButtonFactory.create((Composite)other, (int)32, (String)"Word Wrap", (Listener)new Listener(){

            public void handleEvent(Event event) {
                int i = 0;
                while (i < GridExampleTab.this.grid.getColumns().length) {
                    GridExampleTab.this.grid.getColumn(1).setWordWrap(GridExampleTab.this.columnWordWrap.getSelection());
                    ++i;
                }
            }
        }, (boolean)false);
    }

    public Control createControl(Composite parent) {
        int style = 0;
        if (this.vScroll.getSelection()) {
            style |= 0x200;
        }
        if (this.hScroll.getSelection()) {
            style |= 0x100;
        }
        if (this.border.getSelection()) {
            style |= 0x800;
        }
        if (this.single.getSelection()) {
            style |= 4;
        }
        if (this.multi.getSelection()) {
            style |= 2;
        }
        if (this.check.getSelection()) {
            style |= 0x20;
        }
        this.grid = new Grid(parent, style);
        this.grid.setHeaderVisible(true);
        GridColumn col = new GridColumn(this.grid, 0);
        col.setTree(true);
        col.setText("First Column");
        col.setWidth(140);
        int groupStyle = 0;
        if (this.toggle.getSelection()) {
            groupStyle |= 2;
        }
        GridColumnGroup group = new GridColumnGroup(this.grid, groupStyle);
        group.setText("Column Grouping");
        int colStyle = 0;
        if (this.left.getSelection()) {
            colStyle |= 0x4000;
        }
        if (this.center.getSelection()) {
            colStyle |= 0x1000000;
        }
        if (this.right.getSelection()) {
            colStyle |= 0x20000;
        }
        if (this.columnCheck.getSelection()) {
            colStyle |= 0x20;
        }
        GridColumn col2 = new GridColumn(group, colStyle);
        col2.setText("The Column #2");
        col2.setWidth(230);
        col2.setResizeable(false);
        final GridColumn col3 = new GridColumn(group, 0);
        col3.setSummary(false);
        col3.setText("Click me");
        col3.setWidth(100);
        col3.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (col3.getSort() == 128) {
                    col3.setSort(1024);
                } else {
                    col3.setSort(128);
                }
            }
        });
        GridItem item = new GridItem(this.grid, 0);
        item.setText("Item #000000000000000000000");
        item.setText(1, "Test data ");
        item.setText(2, "asdfjas;dlfjk");
        item.setColumnSpan(2, 1);
        item.setImage(ExamplesView.getImage((String)"icons/eclipse.png"));
        item.setToolTipText(0, "my tooltip 1");
        item.setToolTipText(1, "tooltip2");
        item.setToolTipText(2, "test tooltip on 3");
        GridItem item2 = new GridItem(item, 0);
        item2.setText("first tree");
        item2.setText(1, "first tree");
        item2.setToolTipText(0, "hi");
        item2.setToolTipText(1, "more tooltips");
        item2 = new GridItem(item, 0);
        item2.setText("first tree");
        item2.setText(1, "first tree");
        item2 = new GridItem(item, 0, 0);
        item2.setText("should be 1111");
        item2.setText(1, "first tree");
        GridItem item22 = new GridItem(item2, 0);
        item22.setText("second tree");
        item22.setText(1, "this is a readonly checkbox (if SWT.CHECK)");
        item22.setChecked(1, true);
        item22.setGrayed(1, true);
        item22.setCheckable(1, false);
        GridItem item55 = new GridItem(this.grid, 0);
        item55.setText("Item #55");
        item55.setText(1, "This cell spans over many columns, use setColumnSpan method to achieve this");
        item55.setChecked(1, true);
        item55.setColumnSpan(1, 2);
        GridItem item52 = new GridItem(item55, 0);
        item52.setText("second tree");
        item52.setText(1, "second tree");
        int i = 3;
        while (i < 13) {
            GridItem item3 = new GridItem(this.grid, 0);
            item3.setText("Item #" + i);
            item3.setText(1, "Test data ");
            item3.setText(2, "asdfjas;dlfjk");
            if (i == 5) {
                Font f = new Font((Device)Display.getCurrent(), "Tahoma", 8, 3);
                item3.setFont(2, f);
                item3.setForeground(2, Display.getCurrent().getSystemColor(12));
            }
            ++i;
        }
        GridColumn col4 = new GridColumn(this.grid, 0);
        col4.setText("4th col");
        col4.setWidth(50);
        this.grid.setRowHeaderVisible(this.showRowHeader.getSelection());
        this.grid.setHeaderVisible(this.showHeader.getSelection());
        this.grid.setLinesVisible(this.showLines.getSelection());
        this.grid.setColumnScrolling(this.columnScrolling.getSelection());
        int i2 = 0;
        while (i2 < this.grid.getColumns().length) {
            this.grid.getColumn(i2).setMoveable(this.moveableColumns.getSelection());
            ++i2;
        }
        i2 = 0;
        while (i2 < this.grid.getColumns().length) {
            this.grid.getColumn(i2).setResizeable(this.resizeableColumns.getSelection());
            ++i2;
        }
        this.grid.setSelectionEnabled(this.selectionEnabled.getSelection());
        this.grid.setCellSelectionEnabled(this.cellSelection.getSelection());
        this.grid.getColumn(1).setCellSelectionEnabled(this.columnCellSelection.getSelection());
        this.grid.getColumn(1).setWordWrap(this.columnWordWrap.getSelection());
        this.grid.setRowsResizeable(this.rowsResizable.getSelection());
        if (this.rowHeight.getSelection() == 0) {
            this.rowHeight.setSelection(this.grid.getItemHeight());
        } else {
            this.grid.setItemHeight(this.rowHeight.getSelection());
        }
        i2 = 0;
        while (i2 < this.grid.getColumns().length) {
            this.addEventParticipant((Widget)this.grid.getColumn(i2));
            ++i2;
        }
        i2 = 0;
        while (i2 < this.grid.getColumnGroups().length) {
            this.addEventParticipant((Widget)this.grid.getColumnGroup(i2));
            ++i2;
        }
        i2 = 0;
        while (i2 < this.grid.getItems().length) {
            this.addEventParticipant((Widget)this.grid.getItem(i2));
            ++i2;
        }
        return this.grid;
    }

    public String[] createLinks() {
        String[] links = new String[]{"<a href=\"http://www.eclipse.org/nebula/widgets/grid/grid.php\">Grid Home Page</a>", "<a href=\"http://www.eclipse.org/nebula/widgets/grid/snippets.php\">Snippets</a>", "<a href=\"https://bugs.eclipse.org/bugs/buglist.cgi?query_format=advanced&short_desc_type=allwordssubstr&short_desc=&classification=Technology&product=Nebula&component=Grid&long_desc_type=allwordssubstr&long_desc=&bug_file_loc_type=allwordssubstr&bug_file_loc=&status_whiteboard_type=allwordssubstr&status_whiteboard=&keywords_type=allwords&keywords=&emailtype1=substring&email1=&emailtype2=substring&email2=&bugidtype=include&bug_id=&votes=&chfieldfrom=&chfieldto=Now&chfieldvalue=&cmdtype=doit&order=Reuse+same+sort+as+last+time&field0-0-0=noop&type0-0-0=noop&value0-0-0=\">Bugs</a>"};
        return links;
    }
}

